/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.PrimitiveFactory;
import org.simpleframework.xml.core.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

class Primitive
implements Converter {
    private final PrimitiveFactory factory;
    private final Context context;
    private final String empty;
    private final Class field;

    public Primitive(Context context, Class type) {
        this(context, type, null);
    }

    public Primitive(Context context, Class type, String empty) {
        this.factory = new PrimitiveFactory(context, type);
        this.context = context;
        this.empty = empty;
        this.field = type;
    }

    public Object read(InputNode node) throws Exception {
        if (node.isElement()) {
            return this.readElement(node);
        }
        return this.read(node, this.field);
    }

    public Object read(InputNode node, Object value) throws Exception {
        if (value != null) {
            throw new PersistenceException("Can not read existing %s", this.field);
        }
        return this.read(node);
    }

    public Object read(InputNode node, Class type) throws Exception {
        String value = node.getValue();
        if (value == null) {
            return null;
        }
        if (this.empty != null && value.equals(this.empty)) {
            return this.empty;
        }
        return this.readTemplate(value, type);
    }

    private Object readElement(InputNode node) throws Exception {
        Type type = this.factory.getInstance(node);
        if (!type.isReference()) {
            return this.readElement(node, type);
        }
        return type.getInstance();
    }

    private Object readElement(InputNode node, Type type) throws Exception {
        Object value = this.read(node, this.field);
        if (value != null) {
            return type.getInstance(value);
        }
        return value;
    }

    private Object readTemplate(String value, Class type) throws Exception {
        String text = this.context.getProperty(value);
        if (text != null) {
            return this.factory.getInstance(text, type);
        }
        return null;
    }

    public boolean validate(InputNode node) throws Exception {
        if (node.isElement()) {
            this.validateElement(node);
        } else {
            node.getValue();
        }
        return true;
    }

    private boolean validateElement(InputNode node) throws Exception {
        Type type = this.factory.getInstance(node);
        if (!type.isReference()) {
            type.getInstance(type);
        }
        return true;
    }

    public void write(OutputNode node, Object source) throws Exception {
        String text = this.factory.getText(source);
        if (text != null) {
            node.setValue(text);
        }
    }
}

