/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Entry;
import org.simpleframework.xml.core.Primitive;
import org.simpleframework.xml.core.PrimitiveFactory;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Style;

class PrimitiveValue
implements Converter {
    private final PrimitiveFactory factory;
    private final Context context;
    private final Primitive root;
    private final Style style;
    private final Entry entry;
    private final Class type;

    public PrimitiveValue(Context context, Entry entry, Class type) {
        this.factory = new PrimitiveFactory(context, type);
        this.root = new Primitive(context, type);
        this.style = context.getStyle();
        this.context = context;
        this.entry = entry;
        this.type = type;
    }

    public Object read(InputNode node) throws Exception {
        String name = this.entry.getValue();
        if (name == null) {
            name = this.context.getName(this.type);
        }
        if (this.entry.isInline()) {
            return this.root.read(node);
        }
        return this.read(node, name);
    }

    private Object read(InputNode node, String key) throws Exception {
        String name = this.style.getAttribute(key);
        InputNode child = node.getNext(name);
        if (child == null) {
            return null;
        }
        return this.root.read(child);
    }

    public boolean validate(InputNode node) throws Exception {
        String name = this.entry.getValue();
        if (name == null) {
            name = this.context.getName(this.type);
        }
        return this.validate(node, name);
    }

    private boolean validate(InputNode node, String key) throws Exception {
        String name = this.style.getAttribute(key);
        if (!this.entry.isInline() && (node = node.getNext(name)) == null) {
            return true;
        }
        return this.root.validate(node);
    }

    public void write(OutputNode node, Object item) throws Exception {
        String name = this.entry.getValue();
        if (name == null) {
            name = this.context.getName(this.type);
        }
        this.write(node, item, name);
    }

    private void write(OutputNode node, Object item, String key) throws Exception {
        String name = this.style.getAttribute(key);
        if (!this.entry.isInline()) {
            node = node.getChild(name);
        }
        if (item != null && !this.isOverridden(node, item)) {
            this.root.write(node, item);
        }
    }

    private boolean isOverridden(OutputNode node, Object value) throws Exception {
        return this.factory.setOverride(this.type, value, node);
    }
}

