/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.filter.Filter;
import org.simpleframework.xml.load.DefaultStyle;
import org.simpleframework.xml.load.PersistenceException;
import org.simpleframework.xml.load.Scanner;
import org.simpleframework.xml.load.ScannerFactory;
import org.simpleframework.xml.load.Schema;
import org.simpleframework.xml.load.Session;
import org.simpleframework.xml.load.Strategy;
import org.simpleframework.xml.load.TemplateEngine;
import org.simpleframework.xml.load.TemplateFilter;
import org.simpleframework.xml.load.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.NodeMap;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Style;

class Source {
    private TemplateEngine engine;
    private Strategy strategy;
    private Session session;
    private Filter filter;
    private Style style;

    public Source(Strategy strategy, Filter data, Style style) {
        this.filter = new TemplateFilter(this, data);
        this.engine = new TemplateEngine(this.filter);
        this.session = new Session();
        this.strategy = strategy;
        this.style = style;
    }

    public Session getSession() {
        return this.session;
    }

    public Style getStyle() {
        if (this.style == null) {
            this.style = new DefaultStyle();
        }
        return this.style;
    }

    private Scanner getScanner(Class type) throws Exception {
        return ScannerFactory.getInstance(type);
    }

    public Schema getSchema(Object source) throws Exception {
        return this.getSchema(source.getClass());
    }

    public Schema getSchema(Class type) throws Exception {
        Scanner schema = this.getScanner(type);
        if (schema == null) {
            throw new PersistenceException("Invalid schema class %s", type);
        }
        return new Schema(schema, this);
    }

    public Object getAttribute(Object key) {
        return this.session.get(key);
    }

    public Type getOverride(Class type, InputNode node) throws Exception {
        NodeMap map = node.getAttributes();
        if (node.isRoot()) {
            return this.strategy.getRoot(type, map, this.session);
        }
        return this.strategy.getElement(type, map, this.session);
    }

    public boolean setOverride(Class type, Object value, OutputNode node) throws Exception {
        NodeMap map = node.getAttributes();
        if (node.isRoot()) {
            return this.strategy.setRoot(type, value, map, this.session);
        }
        return this.strategy.setElement(type, value, map, this.session);
    }

    public String getProperty(String text) {
        return this.engine.process(text);
    }
}

