/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.Entry;
import org.simpleframework.xml.load.Factory;
import org.simpleframework.xml.load.Primitive;
import org.simpleframework.xml.load.PrimitiveFactory;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Style;

class PrimitiveKey
implements Converter {
    private final PrimitiveFactory factory;
    private final Primitive primitive;
    private final Style style;
    private final Entry entry;
    private final Class type;

    public PrimitiveKey(Source root, Entry entry, Class type) {
        this.factory = new PrimitiveFactory(root, type);
        this.primitive = new Primitive(root, type);
        this.style = root.getStyle();
        this.entry = entry;
        this.type = type;
    }

    public Object read(InputNode node) throws Exception {
        String name = this.entry.getKey();
        if (name == null) {
            name = Factory.getName(this.type);
        }
        if (!this.entry.isAttribute()) {
            return this.readElement(node, name);
        }
        return this.readAttribute(node, name);
    }

    private Object readAttribute(InputNode node, String key) throws Exception {
        String name = this.style.getAttribute(key);
        InputNode child = node.getAttribute(name);
        if (child == null) {
            return null;
        }
        return this.primitive.read(child);
    }

    private Object readElement(InputNode node, String key) throws Exception {
        String name = this.style.getElement(key);
        InputNode child = node.getNext(name);
        if (child == null) {
            return null;
        }
        return this.primitive.read(child);
    }

    public boolean validate(InputNode node) throws Exception {
        String name = this.entry.getKey();
        if (name == null) {
            name = Factory.getName(this.type);
        }
        if (!this.entry.isAttribute()) {
            return this.validateElement(node, name);
        }
        return this.validateAttribute(node, name);
    }

    private boolean validateAttribute(InputNode node, String key) throws Exception {
        String name = this.style.getElement(key);
        InputNode child = node.getAttribute(name);
        if (child == null) {
            return true;
        }
        return this.primitive.validate(child);
    }

    private boolean validateElement(InputNode node, String key) throws Exception {
        String name = this.style.getElement(key);
        InputNode child = node.getNext(name);
        if (child == null) {
            return true;
        }
        return this.primitive.validate(child);
    }

    public void write(OutputNode node, Object item) throws Exception {
        if (!this.entry.isAttribute()) {
            this.writeElement(node, item);
        } else if (item != null) {
            this.writeAttribute(node, item);
        }
    }

    private void writeElement(OutputNode node, Object item) throws Exception {
        String key = this.entry.getKey();
        if (key == null) {
            key = Factory.getName(this.type);
        }
        String name = this.style.getElement(key);
        OutputNode child = node.getChild(name);
        if (item != null && !this.isOverridden(child, item)) {
            this.primitive.write(child, item);
        }
    }

    private void writeAttribute(OutputNode node, Object item) throws Exception {
        String text = this.factory.getText(item);
        String key = this.entry.getKey();
        if (key == null) {
            key = Factory.getName(this.type);
        }
        String name = this.style.getAttribute(key);
        if (text != null) {
            node.setAttribute(name, text);
        }
    }

    private boolean isOverridden(OutputNode node, Object item) throws Exception {
        return this.factory.setOverride(this.type, item, node);
    }
}

