/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.load.ClassType;
import org.simpleframework.xml.load.Factory;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.Type;
import org.simpleframework.xml.stream.InputNode;

class PrimitiveFactory
extends Factory {
    public PrimitiveFactory(Source root, Class field) {
        super(root, field);
    }

    public Type getInstance(InputNode node) throws Exception {
        Type type = this.getOverride(node);
        if (type == null) {
            return new ClassType(this.field);
        }
        return type;
    }

    public Object getInstance(String text) throws Exception {
        return this.getInstance(text, this.field);
    }

    public Object getInstance(String text, Class type) throws Exception {
        if (type == String.class) {
            return text;
        }
        if (this.field.isEnum()) {
            return Enum.valueOf(type, text);
        }
        return transform.read(text, type);
    }

    public String getText(Object source) throws Exception {
        Class<?> type = source.getClass();
        if (type.isEnum()) {
            Enum value = (Enum)source;
            return value.name();
        }
        return transform.write(source, type);
    }
}

