/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.load.Contact;
import org.simpleframework.xml.load.Factory;
import org.simpleframework.xml.load.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Signature {
    private Annotation marker;
    private Contact contact;
    private Label label;

    public Signature(Contact contact, Label label) {
        this.marker = contact.getAnnotation();
        this.contact = contact;
        this.label = label;
    }

    public Contact getContact() {
        return this.contact;
    }

    public Class getDependant() throws Exception {
        return this.label.getDependant();
    }

    public String getEntry() throws Exception {
        String name;
        Class<?> type = this.getDependant();
        if (type.isArray()) {
            type = type.getComponentType();
        }
        if ((name = this.getName(type)) == null) {
            return null;
        }
        return name.intern();
    }

    private String getName(Class type) throws Exception {
        String name = this.getRoot(type);
        if (name != null) {
            return name;
        }
        name = type.getSimpleName();
        return Introspector.decapitalize(name);
    }

    private String getRoot(Class type) {
        Class real = type;
        while (type != null) {
            String name = this.getRoot(real, type);
            if (name != null) {
                return name;
            }
            type = type.getSuperclass();
        }
        return null;
    }

    private String getRoot(Class<?> real, Class<?> type) {
        String name = type.getSimpleName();
        if (type.isAnnotationPresent(Root.class)) {
            Root root = type.getAnnotation(Root.class);
            String text = root.name();
            if (!this.isEmpty(text)) {
                return text;
            }
            return Introspector.decapitalize(name);
        }
        return null;
    }

    public String getName() throws Exception {
        String entry = this.label.getEntry();
        if (!this.label.isInline()) {
            entry = this.getDefault();
        }
        return entry.intern();
    }

    private String getDefault() throws Exception {
        String name = this.label.getOverride();
        if (!this.isEmpty(name)) {
            return name;
        }
        return this.contact.getName();
    }

    public boolean isPrimitive(Class type) throws Exception {
        if (type != null) {
            return Factory.isPrimitive(type);
        }
        return false;
    }

    public boolean isEmpty(String value) {
        if (value != null) {
            return value.length() == 0;
        }
        return true;
    }

    public String toString() {
        return String.format("%s on %s", this.marker, this.contact);
    }
}

