/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.load.AttributeException;
import org.simpleframework.xml.load.Commit;
import org.simpleframework.xml.load.Complete;
import org.simpleframework.xml.load.Conduit;
import org.simpleframework.xml.load.Contact;
import org.simpleframework.xml.load.ElementException;
import org.simpleframework.xml.load.FieldScanner;
import org.simpleframework.xml.load.Label;
import org.simpleframework.xml.load.LabelFactory;
import org.simpleframework.xml.load.LabelMap;
import org.simpleframework.xml.load.MethodScanner;
import org.simpleframework.xml.load.Persist;
import org.simpleframework.xml.load.PersistenceException;
import org.simpleframework.xml.load.Replace;
import org.simpleframework.xml.load.Resolve;
import org.simpleframework.xml.load.TextException;
import org.simpleframework.xml.load.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Scanner {
    private LabelMap attributes = new LabelMap(this);
    private LabelMap elements = new LabelMap(this);
    private Method commit;
    private Method validate;
    private Method persist;
    private Method complete;
    private Method replace;
    private Method resolve;
    private Label text;
    private Order order;
    private Root root;
    private String name;
    private boolean primitive;

    public Scanner(Class type) throws Exception {
        this.scan(type);
    }

    public LabelMap getAttributes() {
        return this.attributes.clone();
    }

    public LabelMap getElements() {
        return this.elements.clone();
    }

    public Label getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public Method getCommit() {
        return this.commit;
    }

    public Conduit getConduit() {
        return new Conduit(this);
    }

    public Method getValidate() {
        return this.validate;
    }

    public Method getPersist() {
        return this.persist;
    }

    public Method getComplete() {
        return this.complete;
    }

    public Method getReplace() {
        return this.replace;
    }

    public Method getResolve() {
        return this.resolve;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    private boolean isEmpty() {
        if (!this.elements.isEmpty()) {
            return false;
        }
        if (!this.attributes.isEmpty()) {
            return false;
        }
        if (this.text != null) {
            return false;
        }
        return this.root == null;
    }

    public boolean isStrict() {
        if (this.root != null) {
            return this.root.strict();
        }
        return true;
    }

    private void scan(Class type) throws Exception {
        Class real = type;
        while (type != null) {
            if (this.root == null) {
                this.root(type);
            }
            if (this.order == null) {
                this.order(type);
            }
            this.scan(real, type);
            type = type.getSuperclass();
        }
        this.process(real);
    }

    private void scan(Class real, Class type) throws Exception {
        Method[] method = type.getDeclaredMethods();
        for (int i = 0; i < method.length; ++i) {
            Method next = method[i];
            if (!next.isAccessible()) {
                next.setAccessible(true);
            }
            this.scan(next);
        }
    }

    private void validate(Class type) throws Exception {
        if (this.text != null) {
            if (!this.elements.isEmpty()) {
                throw new TextException("Elements used with %s in %s", this.text, type);
            }
        } else {
            this.primitive = this.isEmpty();
        }
        if (this.order != null) {
            this.validateElements(type);
            this.validateAttributes(type);
        }
    }

    private void validateElements(Class type) throws Exception {
        for (String name : this.order.elements()) {
            Label label = (Label)this.elements.get(name);
            if (label != null) continue;
            throw new ElementException("Ordered element '%s' missing for %s", name, type);
        }
    }

    private void validateAttributes(Class type) throws Exception {
        for (String name : this.order.attributes()) {
            Label label = (Label)this.attributes.get(name);
            if (label != null) continue;
            throw new AttributeException("Ordered attribute '%s' missing for %s", name, type);
        }
    }

    private void root(Class<?> type) {
        String real;
        String text = real = type.getSimpleName();
        if (type.isAnnotationPresent(Root.class)) {
            this.root = type.getAnnotation(Root.class);
            text = this.root.name();
            if (this.isEmpty(text)) {
                text = Introspector.decapitalize(real);
            }
            this.name = text.intern();
        }
    }

    private void order(Class<?> type) {
        if (type.isAnnotationPresent(Order.class)) {
            this.order = type.getAnnotation(Order.class);
            for (String name : this.order.elements()) {
                this.elements.put(name, null);
            }
            for (String name : this.order.attributes()) {
                this.attributes.put(name, null);
            }
        }
    }

    private boolean isEmpty(String value) {
        return value.length() == 0;
    }

    private void process(Class type) throws Exception {
        this.field(type);
        this.method(type);
        this.validate(type);
    }

    public void field(Class type) throws Exception {
        FieldScanner list = new FieldScanner(type);
        for (Contact contact : list) {
            this.scan(contact, contact.getAnnotation());
        }
    }

    public void method(Class type) throws Exception {
        MethodScanner list = new MethodScanner(type);
        for (Contact contact : list) {
            this.scan(contact, contact.getAnnotation());
        }
    }

    private void scan(Contact field, Annotation label) throws Exception {
        if (label instanceof Attribute) {
            this.process(field, label, this.attributes);
        }
        if (label instanceof ElementList) {
            this.process(field, label, this.elements);
        }
        if (label instanceof ElementArray) {
            this.process(field, label, this.elements);
        }
        if (label instanceof ElementMap) {
            this.process(field, label, this.elements);
        }
        if (label instanceof Element) {
            this.process(field, label, this.elements);
        }
        if (label instanceof Text) {
            this.process(field, label);
        }
    }

    private void process(Contact field, Annotation type) throws Exception {
        Label label = LabelFactory.getInstance(field, type);
        if (this.text != null) {
            throw new TextException("Multiple text annotations in %s", type);
        }
        this.text = label;
    }

    private void process(Contact field, Annotation type, LabelMap map) throws Exception {
        Label label = LabelFactory.getInstance(field, type);
        String name = label.getName();
        if (map.get(name) != null) {
            throw new PersistenceException("Annotation of name '%s' declared twice", name);
        }
        map.put(name, label);
    }

    private void scan(Method method) {
        if (this.commit == null) {
            this.commit(method);
        }
        if (this.validate == null) {
            this.validate(method);
        }
        if (this.persist == null) {
            this.persist(method);
        }
        if (this.complete == null) {
            this.complete(method);
        }
        if (this.replace == null) {
            this.replace(method);
        }
        if (this.resolve == null) {
            this.resolve(method);
        }
    }

    private void replace(Method method) {
        Replace mark = method.getAnnotation(Replace.class);
        if (mark != null) {
            this.replace = method;
        }
    }

    private void resolve(Method method) {
        Resolve mark = method.getAnnotation(Resolve.class);
        if (mark != null) {
            this.resolve = method;
        }
    }

    private void commit(Method method) {
        Commit mark = method.getAnnotation(Commit.class);
        if (mark != null) {
            this.commit = method;
        }
    }

    private void validate(Method method) {
        Validate mark = method.getAnnotation(Validate.class);
        if (mark != null) {
            this.validate = method;
        }
    }

    private void persist(Method method) {
        Persist mark = method.getAnnotation(Persist.class);
        if (mark != null) {
            this.persist = method;
        }
    }

    private void complete(Method method) {
        Complete mark = method.getAnnotation(Complete.class);
        if (mark != null) {
            this.complete = method;
        }
    }
}

