/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.load.AttributeLabel;
import org.simpleframework.xml.load.CacheLabel;
import org.simpleframework.xml.load.Contact;
import org.simpleframework.xml.load.ElementArrayLabel;
import org.simpleframework.xml.load.ElementLabel;
import org.simpleframework.xml.load.ElementListLabel;
import org.simpleframework.xml.load.ElementMapLabel;
import org.simpleframework.xml.load.Label;
import org.simpleframework.xml.load.PersistenceException;
import org.simpleframework.xml.load.TextLabel;

final class LabelFactory {
    LabelFactory() {
    }

    public static Label getInstance(Contact contact, Annotation label) throws Exception {
        Label value = LabelFactory.getLabel(contact, label);
        if (value == null) {
            return value;
        }
        return new CacheLabel(value);
    }

    private static Label getLabel(Contact contact, Annotation label) throws Exception {
        Constructor factory = LabelFactory.getConstructor(label);
        if (!factory.isAccessible()) {
            factory.setAccessible(true);
        }
        return (Label)factory.newInstance(contact, label);
    }

    private static Constructor getConstructor(Annotation label) throws Exception {
        return LabelFactory.getEntry(label).getConstructor();
    }

    private static Entry getEntry(Annotation label) throws Exception {
        if (label instanceof Element) {
            return new Entry(ElementLabel.class, Element.class);
        }
        if (label instanceof ElementList) {
            return new Entry(ElementListLabel.class, ElementList.class);
        }
        if (label instanceof ElementArray) {
            return new Entry(ElementArrayLabel.class, ElementArray.class);
        }
        if (label instanceof ElementMap) {
            return new Entry(ElementMapLabel.class, ElementMap.class);
        }
        if (label instanceof Attribute) {
            return new Entry(AttributeLabel.class, Attribute.class);
        }
        if (label instanceof Text) {
            return new Entry(TextLabel.class, Text.class);
        }
        throw new PersistenceException("Annotation %s not supported", label);
    }

    private static class Entry {
        public Class argument;
        public Class label;

        public Entry(Class label, Class argument) {
            this.argument = argument;
            this.label = label;
        }

        public Constructor getConstructor() throws Exception {
            return this.getConstructor(Contact.class);
        }

        private Constructor getConstructor(Class type) throws Exception {
            return this.label.getConstructor(type, this.argument);
        }
    }
}

