/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.lang.reflect.Array;
import org.simpleframework.xml.load.ArrayFactory;
import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.Traverser;
import org.simpleframework.xml.load.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

class CompositeArray
implements Converter {
    private final ArrayFactory factory;
    private final Traverser root;
    private final String parent;
    private final Class entry;

    public CompositeArray(Source root, Class field, Class entry, String parent) {
        this.factory = new ArrayFactory(root, field);
        this.root = new Traverser(root);
        this.parent = parent;
        this.entry = entry;
    }

    public Object read(InputNode node) throws Exception {
        Type type = this.factory.getInstance(node);
        Object list = type.getInstance();
        if (!type.isReference()) {
            return this.read(node, list);
        }
        return list;
    }

    private Object read(InputNode node, Object list) throws Exception {
        int i = 0;
        InputNode next;
        while ((next = node.getNext()) != null) {
            this.read(next, list, i);
            ++i;
        }
        return list;
    }

    private void read(InputNode node, Object list, int index) throws Exception {
        Object value = null;
        if (!node.isEmpty()) {
            value = this.root.read(node, this.entry);
        }
        Array.set(list, index, value);
    }

    public boolean validate(InputNode node) throws Exception {
        Type type = this.factory.getInstance(node);
        if (!type.isReference()) {
            Object real = type.getInstance(type);
            Class expect = type.getType();
            return this.validate(node, expect);
        }
        return true;
    }

    private boolean validate(InputNode node, Class type) throws Exception {
        int i = 0;
        InputNode next;
        while ((next = node.getNext()) != null) {
            if (!next.isEmpty()) {
                this.root.validate(next, type);
            }
            ++i;
        }
        return true;
    }

    public void write(OutputNode node, Object source) throws Exception {
        int size = Array.getLength(source);
        for (int i = 0; i < size; ++i) {
            Object item = Array.get(source, i);
            this.root.write(node, item, this.entry, this.parent);
        }
        node.commit();
    }
}

