/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.load.AttributeException;
import org.simpleframework.xml.load.Collector;
import org.simpleframework.xml.load.Contact;
import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.ElementException;
import org.simpleframework.xml.load.Label;
import org.simpleframework.xml.load.LabelMap;
import org.simpleframework.xml.load.ObjectFactory;
import org.simpleframework.xml.load.PersistenceException;
import org.simpleframework.xml.load.Schema;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.TextException;
import org.simpleframework.xml.load.Type;
import org.simpleframework.xml.load.ValueRequiredException;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.NodeMap;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Position;

class Composite
implements Converter {
    private final ObjectFactory factory;
    private final Collector store;
    private final Source root;
    private final Class type;

    public Composite(Source root, Class type) {
        this.factory = new ObjectFactory(root, type);
        this.store = new Collector();
        this.root = root;
        this.type = type;
    }

    public Object read(InputNode node) throws Exception {
        Type type = this.factory.getInstance(node);
        Object source = type.getInstance();
        if (!type.isReference()) {
            return this.read(node, source);
        }
        return source;
    }

    public Object read(InputNode node, Object source) throws Exception {
        Schema schema = this.root.getSchema(source);
        this.read(node, source, schema);
        this.store.commit(source);
        schema.validate(source);
        schema.commit(source);
        return this.readResolve(node, source, schema);
    }

    private Object readResolve(InputNode node, Object source, Schema schema) throws Exception {
        if (source != null) {
            Position line = node.getPosition();
            Object value = schema.resolve(source);
            Class<?> real = value.getClass();
            if (!this.type.isAssignableFrom(real)) {
                throw new ElementException("Type %s does not match %s at %s", real, this.type, line);
            }
            return value;
        }
        return source;
    }

    private void read(InputNode node, Object source, Schema schema) throws Exception {
        this.readText(node, source, schema);
        this.readAttributes(node, source, schema);
        this.readElements(node, source, schema);
    }

    private void readAttributes(InputNode node, Object source, Schema schema) throws Exception {
        NodeMap list = node.getAttributes();
        LabelMap map = schema.getAttributes();
        for (String name : list) {
            this.readAttribute(node.getAttribute(name), source, map);
        }
        this.validate(node, map, source);
    }

    private void readElements(InputNode node, Object source, Schema schema) throws Exception {
        InputNode child;
        LabelMap map = schema.getElements();
        while ((child = node.getNext()) != null) {
            this.readElement(child, source, map);
        }
        this.validate(node, map, source);
    }

    private void readText(InputNode node, Object source, Schema schema) throws Exception {
        Label label = schema.getText();
        if (label != null) {
            this.read(node, source, label);
        }
    }

    private void readAttribute(InputNode node, Object source, LabelMap map) throws Exception {
        Position line = node.getPosition();
        String name = node.getName();
        Label label = map.take(name);
        if (label == null) {
            if (map.isStrict()) {
                throw new AttributeException("Attribute '%s' does not exist at %s", name, line);
            }
        } else {
            this.read(node, source, label);
        }
    }

    private void readElement(InputNode node, Object source, LabelMap map) throws Exception {
        String name = node.getName();
        Label label = map.take(name);
        if (label == null) {
            label = (Label)this.store.get(name);
        }
        if (label == null) {
            Position line = node.getPosition();
            if (map.isStrict()) {
                throw new ElementException("Element '%s' does not exist at %s", name, line);
            }
            node.skip();
        } else {
            this.read(node, source, label);
        }
    }

    private void read(InputNode node, Object source, Label label) throws Exception {
        Converter reader = label.getConverter(this.root);
        Object object = reader.read(node);
        if (object == null) {
            Position line = node.getPosition();
            Class<?> type = source.getClass();
            if (label.isRequired()) {
                throw new ValueRequiredException("Empty value for %s in %s at %s", label, type, line);
            }
        } else if (object != label.getEmpty(this.root)) {
            this.store.put(label, object);
        }
    }

    private void validate(InputNode node, LabelMap map, Object source) throws Exception {
        Position line = node.getPosition();
        Class<?> type = source.getClass();
        for (Label label : map) {
            if (label.isRequired()) {
                throw new ValueRequiredException("Unable to satisfy %s for %s at %s", label, type, line);
            }
            Object value = label.getEmpty(this.root);
            if (value == null) continue;
            this.store.put(label, value);
        }
    }

    public boolean validate(InputNode node) throws Exception {
        Type type = this.factory.getInstance(node);
        if (!type.isReference()) {
            Object real = type.getInstance(type);
            Class expect = type.getType();
            return this.validate(node, expect);
        }
        return true;
    }

    private boolean validate(InputNode node, Class type) throws Exception {
        Schema schema = this.root.getSchema(type);
        this.validateText(node, schema);
        this.validateAttributes(node, schema);
        this.validateElements(node, schema);
        return node.isElement();
    }

    private void validateAttributes(InputNode node, Schema schema) throws Exception {
        NodeMap list = node.getAttributes();
        LabelMap map = schema.getAttributes();
        for (String name : list) {
            this.validateAttribute(node.getAttribute(name), map);
        }
        this.validate(node, map);
    }

    private void validateElements(InputNode node, Schema schema) throws Exception {
        InputNode child;
        LabelMap map = schema.getElements();
        while ((child = node.getNext()) != null) {
            this.validateElement(child, map);
        }
        this.validate(node, map);
    }

    private void validateText(InputNode node, Schema schema) throws Exception {
        Label label = schema.getText();
        if (label != null) {
            this.validate(node, label);
        }
    }

    private void validateAttribute(InputNode node, LabelMap map) throws Exception {
        Position line = node.getPosition();
        String name = node.getName();
        Label label = map.take(name);
        if (label == null) {
            if (map.isStrict()) {
                throw new AttributeException("Attribute '%s' does not exist at %s", name, line);
            }
        } else {
            this.validate(node, label);
        }
    }

    private void validateElement(InputNode node, LabelMap map) throws Exception {
        String name = node.getName();
        Label label = map.take(name);
        if (label == null) {
            label = (Label)this.store.get(name);
        }
        if (label == null) {
            Position line = node.getPosition();
            if (map.isStrict()) {
                throw new ElementException("Element '%s' does not exist at %s", name, line);
            }
            node.skip();
        } else {
            this.validate(node, label);
        }
    }

    private void validate(InputNode node, Label label) throws Exception {
        Converter reader = label.getConverter(this.root);
        Position line = node.getPosition();
        boolean valid = reader.validate(node);
        if (!valid) {
            throw new PersistenceException("Invalid value for %s in %s at %s", label, this.type, line);
        }
        this.store.put(label, (Object)null);
    }

    private void validate(InputNode node, LabelMap map) throws Exception {
        Position line = node.getPosition();
        for (Label label : map) {
            if (!label.isRequired()) continue;
            throw new ValueRequiredException("Unable to satisfy %s at %s", label, line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputNode node, Object source) throws Exception {
        Schema schema = this.root.getSchema(source);
        try {
            schema.persist(source);
            this.write(node, source, schema);
        }
        finally {
            schema.complete(source);
        }
    }

    private void write(OutputNode node, Object source, Schema schema) throws Exception {
        this.writeAttributes(node, source, schema);
        this.writeElements(node, source, schema);
        this.writeText(node, source, schema);
    }

    private void writeAttributes(OutputNode node, Object source, Schema schema) throws Exception {
        LabelMap attributes = schema.getAttributes();
        for (Label label : attributes) {
            Contact contact = label.getContact();
            Object value = contact.get(source);
            if (value == null) {
                value = label.getEmpty(this.root);
            }
            if (value == null && label.isRequired()) {
                throw new AttributeException("Value for %s is null", label);
            }
            this.writeAttribute(node, value, label);
        }
    }

    private void writeElements(OutputNode node, Object source, Schema schema) throws Exception {
        LabelMap elements = schema.getElements();
        for (Label label : elements) {
            Contact contact = label.getContact();
            Object value = contact.get(source);
            if (value == null && label.isRequired()) {
                throw new ElementException("Value for %s is null", label);
            }
            Object replace = this.writeReplace(value);
            if (replace == null) continue;
            this.writeElement(node, replace, label);
        }
    }

    private Object writeReplace(Object source) throws Exception {
        if (source != null) {
            Schema schema = this.root.getSchema(source);
            return schema.replace(source);
        }
        return source;
    }

    private void writeText(OutputNode node, Object source, Schema schema) throws Exception {
        Label label = schema.getText();
        if (label != null) {
            Contact contact = label.getContact();
            Object value = contact.get(source);
            if (value == null) {
                value = label.getEmpty(this.root);
            }
            if (value == null && label.isRequired()) {
                throw new TextException("Value for %s is null", label);
            }
            this.writeText(node, value, label);
        }
    }

    private void writeAttribute(OutputNode node, Object value, Label label) throws Exception {
        if (value != null) {
            String name = label.getName();
            String text = this.factory.getText(value);
            node.setAttribute(name, text);
        }
    }

    private void writeElement(OutputNode node, Object value, Label label) throws Exception {
        if (value != null) {
            String name = label.getName();
            OutputNode next = node.getChild(name);
            Class type = label.getType();
            if (label.isInline() || !this.isOverridden(next, value, type)) {
                Converter convert = label.getConverter(this.root);
                boolean data = label.isData();
                next.setData(data);
                convert.write(next, value);
            }
        }
    }

    private void writeText(OutputNode node, Object value, Label label) throws Exception {
        if (value != null) {
            String text = this.factory.getText(value);
            boolean data = label.isData();
            node.setData(data);
            node.setValue(text);
        }
    }

    private boolean isOverridden(OutputNode node, Object value, Class type) throws Exception {
        return this.factory.setOverride(type, value, node);
    }
}

