/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.Entry;
import org.simpleframework.xml.load.Factory;
import org.simpleframework.xml.load.Primitive;
import org.simpleframework.xml.load.PrimitiveFactory;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.TextException;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Position;

class PrimitiveValue
implements Converter {
    private final PrimitiveFactory factory;
    private final Primitive primitive;
    private final Entry entry;
    private final Class type;

    public PrimitiveValue(Source root, Entry entry, Class type) {
        this.factory = new PrimitiveFactory(root, type);
        this.primitive = new Primitive(root, type);
        this.entry = entry;
        this.type = type;
    }

    public Object read(InputNode node) throws Exception {
        String name = Factory.getName(this.type);
        if (this.entry.isInline()) {
            return this.primitive.read(node);
        }
        return this.read(node, name);
    }

    private Object read(InputNode node, String name) throws Exception {
        InputNode child = node.getNext(name);
        Position line = node.getPosition();
        if (child == null) {
            throw new TextException("Element '%s' not found at %s", name, line);
        }
        return this.primitive.read(child);
    }

    public boolean validate(InputNode node) throws Exception {
        String name = Factory.getName(this.type);
        if (this.entry.isInline()) {
            return this.primitive.validate(node);
        }
        return this.validate(node, name);
    }

    private boolean validate(InputNode node, String name) throws Exception {
        InputNode child = node.getNext(name);
        Position line = node.getPosition();
        if (child == null) {
            throw new TextException("Element '%s' not found at %s", name, line);
        }
        return this.primitive.validate(child);
    }

    public void write(OutputNode node, Object item) throws Exception {
        String name = Factory.getName(this.type);
        if (!this.entry.isInline()) {
            node = node.getChild(name);
        }
        if (!this.isOverridden(node, item)) {
            this.primitive.write(node, item);
        }
    }

    private boolean isOverridden(OutputNode node, Object item) throws Exception {
        return this.factory.setOverride(this.type, item, node);
    }
}

