/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.simpleframework.xml.load.Contact;
import org.simpleframework.xml.load.MethodPart;

class MethodContact
implements Contact {
    private Annotation label;
    private Method read;
    private Method write;
    private Class[] items;
    private Class item;
    private Class type;
    private String name;

    public MethodContact(MethodPart read, MethodPart write) {
        this.label = read.getAnnotation();
        this.items = read.getDependants();
        this.item = read.getDependant();
        this.write = write.getMethod();
        this.read = read.getMethod();
        this.type = read.getType();
        this.name = read.getName();
    }

    public Class getType() {
        return this.type;
    }

    public Class getDependant() {
        return this.item;
    }

    public Class[] getDependants() {
        return this.items;
    }

    public String getName() {
        return this.name;
    }

    public Annotation getAnnotation() {
        return this.label;
    }

    public void set(Object source, Object value) throws Exception {
        this.write.invoke(source, value);
    }

    public Object get(Object source) throws Exception {
        return this.read.invoke(source, new Object[0]);
    }

    public String toString() {
        return String.format("method '%s'", this.name);
    }
}

