/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.load.CompositeKey;
import org.simpleframework.xml.load.CompositeValue;
import org.simpleframework.xml.load.Contact;
import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.Factory;
import org.simpleframework.xml.load.PersistenceException;
import org.simpleframework.xml.load.PrimitiveKey;
import org.simpleframework.xml.load.PrimitiveValue;
import org.simpleframework.xml.load.Source;

class Entry {
    private static final String DEFAULT_NAME = "entry";
    private ElementMap label;
    private Contact contact;
    private boolean attribute;
    private Class valueType;
    private Class keyType;
    private String entry;
    private String value;
    private String key;

    public Entry(Contact contact, ElementMap label) {
        this.attribute = label.attribute();
        this.entry = label.entry();
        this.value = label.value();
        this.key = label.key();
        this.key = label.key();
        this.contact = contact;
        this.label = label;
    }

    protected Class getKeyType() throws Exception {
        if (this.keyType != null) {
            return this.keyType;
        }
        Class keyType = this.label.keyType();
        if (keyType == Void.TYPE) {
            keyType = this.getDependant(0);
        }
        return keyType;
    }

    public Converter getKey(Source root) throws Exception {
        Class type = this.getKeyType();
        if (Factory.isPrimitive(type)) {
            return new PrimitiveKey(root, this, type);
        }
        return new CompositeKey(root, this, type);
    }

    public boolean isAttribute() {
        return this.attribute;
    }

    protected Class getValueType() throws Exception {
        if (this.valueType != null) {
            return this.valueType;
        }
        Class valueType = this.label.valueType();
        if (valueType == Void.TYPE) {
            valueType = this.getDependant(1);
        }
        return valueType;
    }

    public Converter getValue(Source root) throws Exception {
        Class value = this.getValueType();
        if (Factory.isPrimitive(value)) {
            return new PrimitiveValue(root, this, value);
        }
        return new CompositeValue(root, this, value);
    }

    public boolean isInline() throws Exception {
        String value = this.getValue();
        if (value != null) {
            return true;
        }
        return this.isAttribute();
    }

    private Class getDependant(int index) throws Exception {
        Class[] list = this.contact.getDependants();
        if (list.length < index) {
            throw new PersistenceException("Could not find dependant at index %s", index);
        }
        return list[index];
    }

    public String getKey() throws Exception {
        if (this.key == null) {
            return this.key;
        }
        if (this.isEmpty(this.key)) {
            this.key = null;
        }
        return this.key;
    }

    public String getValue() throws Exception {
        if (this.value == null) {
            return this.value;
        }
        if (this.isEmpty(this.value)) {
            this.value = null;
        }
        return this.value;
    }

    public String getEntry() throws Exception {
        if (this.entry == null) {
            return this.entry;
        }
        if (this.isEmpty(this.entry)) {
            this.entry = DEFAULT_NAME;
        }
        return this.entry;
    }

    private boolean isEmpty(String value) {
        return value.length() == 0;
    }
}

