/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.load.CompositeInlineMap;
import org.simpleframework.xml.load.CompositeMap;
import org.simpleframework.xml.load.Contact;
import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.ElementException;
import org.simpleframework.xml.load.Entry;
import org.simpleframework.xml.load.Label;
import org.simpleframework.xml.load.Signature;
import org.simpleframework.xml.load.Source;

class ElementMapLabel
implements Label {
    private ElementMap label;
    private Signature detail;
    private Entry entry;
    private Class type;
    private Class[] items;
    private String parent;
    private String name;

    public ElementMapLabel(Contact contact, ElementMap label) {
        this.detail = new Signature(contact, this);
        this.entry = new Entry(contact, label);
        this.type = contact.getType();
        this.name = label.name();
        this.label = label;
    }

    public Converter getConverter(Source root) throws Exception {
        if (!this.label.inline()) {
            return new CompositeMap(root, this.entry, this.type);
        }
        return new CompositeInlineMap(root, this.entry, this.type);
    }

    public Class getDependant() throws Exception {
        Contact contact = this.getContact();
        if (this.items == null) {
            this.items = contact.getDependants();
        }
        if (this.items == null) {
            throw new ElementException("Unable to determine type for %s", this.label);
        }
        return this.items[0];
    }

    public String getEntry() throws Exception {
        if (this.detail.isEmpty(this.parent)) {
            this.parent = this.detail.getEntry();
        }
        return this.parent;
    }

    public String getName() throws Exception {
        if (this.label.inline()) {
            return this.entry.getEntry();
        }
        return this.detail.getName();
    }

    public Class getType() {
        return this.type;
    }

    public Contact getContact() {
        return this.detail.getContact();
    }

    public String getOverride() {
        return this.name;
    }

    public boolean isData() {
        return this.label.data();
    }

    public boolean isRequired() {
        return this.label.required();
    }

    public boolean isInline() {
        return this.label.inline();
    }

    public String getEmpty() {
        return null;
    }

    public String toString() {
        return this.detail.toString();
    }
}

