/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.ElementException;
import org.simpleframework.xml.load.Entry;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.Traverser;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Position;

class CompositeValue
implements Converter {
    private final Traverser root;
    private final Class type;

    public CompositeValue(Source root, Entry entry, Class type) throws Exception {
        this.root = new Traverser(root);
        this.type = type;
    }

    public Object read(InputNode node) throws Exception {
        Position line = node.getPosition();
        InputNode next = node.getNext();
        if (next == null) {
            throw new ElementException("Element does not exist at %s", line);
        }
        return this.root.read(next, this.type);
    }

    public boolean validate(InputNode node) throws Exception {
        Position line = node.getPosition();
        InputNode next = node.getNext();
        if (next == null) {
            throw new ElementException("Element does not exist at %s", line);
        }
        return this.root.validate(next, this.type);
    }

    public void write(OutputNode node, Object item) throws Exception {
        if (item != null) {
            this.root.write(node, item, this.type);
        }
    }
}

