/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.util.Map;
import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.ElementException;
import org.simpleframework.xml.load.Entry;
import org.simpleframework.xml.load.MapFactory;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Position;

class CompositeMap
implements Converter {
    private final MapFactory factory;
    private final Converter value;
    private final Converter key;
    private final Entry entry;

    public CompositeMap(Source root, Entry entry, Class type) throws Exception {
        this.factory = new MapFactory(root, type);
        this.value = entry.getValue(root);
        this.key = entry.getKey(root);
        this.entry = entry;
    }

    public Object read(InputNode node) throws Exception {
        Type type = this.factory.getInstance(node);
        Object map = type.getInstance();
        if (!type.isReference()) {
            return this.read(node, map);
        }
        return map;
    }

    private Object read(InputNode node, Object result) throws Exception {
        Map map = (Map)result;
        InputNode next;
        while ((next = node.getNext()) != null) {
            Object key = this.readKey(next);
            Object value = this.readValue(next);
            map.put(key, value);
        }
        return map;
    }

    private Object readKey(InputNode node) throws Exception {
        return this.key.read(node);
    }

    private Object readValue(InputNode node) throws Exception {
        Position line = node.getPosition();
        String name = this.entry.getValue();
        if (name != null) {
            node = node.getNext(name);
        }
        if (node == null) {
            throw new ElementException("Could not find element '%s' at %s", name, line);
        }
        return this.value.read(node);
    }

    public boolean validate(InputNode node) throws Exception {
        Type type = this.factory.getInstance(node);
        if (!type.isReference()) {
            Object real = type.getInstance(type);
            Class expect = type.getType();
            return this.validate(node, expect);
        }
        return true;
    }

    private boolean validate(InputNode node, Class type) throws Exception {
        InputNode next;
        do {
            if ((next = node.getNext()) == null) {
                return true;
            }
            if (this.validateKey(next)) continue;
            return false;
        } while (this.validateValue(next));
        return false;
    }

    private boolean validateKey(InputNode node) throws Exception {
        return this.key.validate(node);
    }

    private boolean validateValue(InputNode node) throws Exception {
        Position line = node.getPosition();
        String name = this.entry.getValue();
        if (name != null) {
            node = node.getNext(name);
        }
        if (node == null) {
            throw new ElementException("Could not find element '%s' at %s", name, line);
        }
        return this.value.validate(node);
    }

    public void write(OutputNode node, Object source) throws Exception {
        Map map = (Map)source;
        for (Object key : map.keySet()) {
            String name = this.entry.getEntry();
            OutputNode next = node.getChild(name);
            Object value = map.get(key);
            if (value == null) continue;
            this.writeKey(next, key);
            this.writeValue(next, value);
        }
    }

    private void writeKey(OutputNode node, Object item) throws Exception {
        this.key.write(node, item);
    }

    private void writeValue(OutputNode node, Object item) throws Exception {
        String name = this.entry.getValue();
        if (name != null) {
            node = node.getChild(name);
        }
        this.value.write(node, item);
    }
}

