/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.ElementException;
import org.simpleframework.xml.load.Entry;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.Traverser;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Position;

class CompositeKey
implements Converter {
    private final Traverser root;
    private final Entry entry;
    private final Class type;

    public CompositeKey(Source root, Entry entry, Class type) throws Exception {
        this.root = new Traverser(root);
        this.entry = entry;
        this.type = type;
    }

    public Object read(InputNode node) throws Exception {
        Position line = node.getPosition();
        String name = this.entry.getKey();
        if (this.entry.isAttribute()) {
            throw new ElementException("Can not have %s as an attribute at %s", this.type, line);
        }
        return this.read(node, name);
    }

    private Object read(InputNode node, String name) throws Exception {
        Position line = node.getPosition();
        if (name != null) {
            node = node.getNext(name);
        }
        if (node == null) {
            throw new ElementException("Element '%s' does not exist at %s", name, line);
        }
        return this.read(node, this.type);
    }

    private Object read(InputNode node, Class type) throws Exception {
        Position line = node.getPosition();
        InputNode next = node.getNext();
        if (next == null) {
            throw new ElementException("Element does not exist at %s for %s", line, type);
        }
        return this.root.read(next, type);
    }

    public boolean validate(InputNode node) throws Exception {
        Position line = node.getPosition();
        String name = this.entry.getKey();
        if (this.entry.isAttribute()) {
            throw new ElementException("Can not have %s as an attribute at %s", this.type, line);
        }
        return this.validate(node, name);
    }

    private boolean validate(InputNode node, String name) throws Exception {
        Position line = node.getPosition();
        if (name != null) {
            node = node.getNext(name);
        }
        if (node == null) {
            throw new ElementException("Element '%s' does not exist at %s", name, line);
        }
        return this.validate(node, this.type);
    }

    private boolean validate(InputNode node, Class type) throws Exception {
        Position line = node.getPosition();
        InputNode next = node.getNext();
        if (next == null) {
            throw new ElementException("Element does not exist at %s for %s", line, type);
        }
        return this.root.validate(next, type);
    }

    public void write(OutputNode node, Object item) throws Exception {
        String name = this.entry.getKey();
        if (this.entry.isAttribute()) {
            throw new ElementException("Can not have %s as an attribute", this.type);
        }
        if (name != null) {
            node = node.getChild(name);
        }
        this.root.write(node, item, this.type);
    }
}

