/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import org.simpleframework.xml.transform.CharacterArrayTransform;
import org.simpleframework.xml.transform.Matcher;
import org.simpleframework.xml.transform.PackageMatcher;
import org.simpleframework.xml.transform.PrimitiveArrayTransform;
import org.simpleframework.xml.transform.Transform;
import org.simpleframework.xml.transform.TransformRequiredException;

class ArrayMatcher
extends PackageMatcher {
    private final Matcher primary;

    public ArrayMatcher(Matcher primary) {
        this.primary = primary;
    }

    public Transform match(Class type) throws Exception {
        Class<?> entry = type.getComponentType();
        if (entry.isPrimitive()) {
            return this.matchPrimitive(entry);
        }
        return this.matchArray(entry);
    }

    private Transform matchPrimitive(Class entry) throws Exception {
        Transform transform = this.primary.match(entry);
        if (entry == Character.TYPE) {
            return new CharacterArrayTransform();
        }
        if (transform == null) {
            throw new TransformRequiredException("Transform for %s not found", entry);
        }
        return new PrimitiveArrayTransform(transform, entry);
    }

    private Transform matchArray(Class entry) throws Exception {
        Class type = this.getArrayClass(entry);
        return (Transform)type.newInstance();
    }
}

