/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.load.ContactList;
import org.simpleframework.xml.load.FieldContact;

class FieldScanner
extends ContactList {
    public FieldScanner(Class type) {
        this.scan(type);
    }

    private void scan(Class type) {
        Class real = type;
        while (type != null) {
            this.scan(real, type);
            type = type.getSuperclass();
        }
    }

    private void scan(Class real, Class type) {
        Field[] field = type.getDeclaredFields();
        for (int i = 0; i < field.length; ++i) {
            this.scan(field[i]);
        }
    }

    public void scan(Field field) {
        Annotation[] list = field.getDeclaredAnnotations();
        for (int i = 0; i < list.length; ++i) {
            this.scan(field, list[i]);
        }
    }

    public void scan(Field field, Annotation label) {
        if (label instanceof Attribute) {
            this.process(field, label);
        }
        if (label instanceof ElementList) {
            this.process(field, label);
        }
        if (label instanceof ElementArray) {
            this.process(field, label);
        }
        if (label instanceof Element) {
            this.process(field, label);
        }
        if (label instanceof Text) {
            this.process(field, label);
        }
    }

    public void process(Field field, Annotation label) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        this.add(new FieldContact(field, label));
    }
}

