/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.load.Contact;
import org.simpleframework.xml.load.ElementException;
import org.simpleframework.xml.load.Factory;
import org.simpleframework.xml.load.Label;
import org.simpleframework.xml.load.RootException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Signature {
    private Annotation marker;
    private Contact contact;
    private Label label;
    private String name;

    public Signature(Contact contact, Label label) {
        this.marker = contact.getAnnotation();
        this.contact = contact;
        this.label = label;
    }

    public Contact getContact() {
        return this.contact;
    }

    public Class getDependant() throws Exception {
        return this.label.getDependant();
    }

    public String getParent() throws Exception {
        Class<Object> type = this.getDependant();
        if (!Factory.isPrimitive(type)) {
            type = Object.class;
        }
        return this.getParent(type);
    }

    private String getParent(Class type) throws Exception {
        String name = type.getSimpleName();
        if (type.isPrimitive()) {
            return name;
        }
        return name.toLowerCase();
    }

    public String getName() throws Exception {
        if (this.name == null) {
            Class type = this.getDependant();
            this.name = !this.label.isInline() ? this.getDefault() : this.getName(type);
        }
        return this.name;
    }

    private String getName(Class type) throws Exception {
        this.name = this.isPrimitive(type) ? this.label.getParent() : this.getRoot();
        return this.name;
    }

    private String getRoot() throws Exception {
        String name = this.label.getOverride();
        if (!this.isEmpty(name)) {
            throw new ElementException("Inline element %s can not have name", this.label);
        }
        Class type = this.getDependant();
        String root = this.getRoot(type);
        if (root == null) {
            throw new RootException("Root required for %s in %s", type, this.label);
        }
        return root;
    }

    private String getRoot(Class type) {
        Class real = type;
        while (type != null) {
            String name = this.getRoot(real, type);
            if (name != null) {
                return name.intern();
            }
            type = type.getSuperclass();
        }
        return null;
    }

    private String getRoot(Class<?> real, Class<?> type) {
        String name = type.getSimpleName();
        if (type.isAnnotationPresent(Root.class)) {
            Root root = type.getAnnotation(Root.class);
            String text = root.name();
            if (!this.isEmpty(text)) {
                return text;
            }
            return Introspector.decapitalize(name);
        }
        return null;
    }

    private String getDefault() {
        String name = this.label.getOverride();
        if (!this.isEmpty(name)) {
            return name;
        }
        return this.contact.getName();
    }

    public boolean isPrimitive(Class type) {
        if (type != null) {
            return Factory.isPrimitive(type);
        }
        return false;
    }

    public boolean isEmpty(String value) {
        return value.length() == 0;
    }

    public String toString() {
        return String.format("%s on %s", this.marker, this.contact);
    }
}

