/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.load.CompositeInlineList;
import org.simpleframework.xml.load.CompositeList;
import org.simpleframework.xml.load.Contact;
import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.ElementException;
import org.simpleframework.xml.load.Label;
import org.simpleframework.xml.load.PrimitiveInlineList;
import org.simpleframework.xml.load.PrimitiveList;
import org.simpleframework.xml.load.Signature;
import org.simpleframework.xml.load.Source;

class ElementListLabel
implements Label {
    private ElementList label;
    private Signature detail;
    private Class type;
    private Class item;
    private String parent;
    private String name;

    public ElementListLabel(Contact contact, ElementList label) {
        this.detail = new Signature(contact, this);
        this.type = contact.getType();
        this.parent = label.parent();
        this.item = label.type();
        this.name = label.name();
        this.label = label;
    }

    public Converter getConverter(Source root) throws Exception {
        String parent = this.getParent();
        if (!this.label.inline()) {
            return this.getConverter(root, parent);
        }
        return this.getInlineConverter(root, parent);
    }

    private Converter getConverter(Source root, String parent) throws Exception {
        Class item = this.getDependant();
        if (!root.isPrimitive(item)) {
            return new CompositeList(root, this.type, item);
        }
        return new PrimitiveList(root, this.type, item, parent);
    }

    private Converter getInlineConverter(Source root, String parent) throws Exception {
        Class item = this.getDependant();
        if (!root.isPrimitive(item)) {
            return new CompositeInlineList(root, this.type, item);
        }
        return new PrimitiveInlineList(root, this.type, item, parent);
    }

    public Class getDependant() throws Exception {
        Contact contact = this.getContact();
        if (this.item == Void.TYPE) {
            this.item = contact.getDependant();
        }
        if (this.item == null) {
            throw new ElementException("Unable to determine type for %s", this.label);
        }
        return this.item;
    }

    public String getParent() throws Exception {
        if (this.detail.isEmpty(this.parent)) {
            this.parent = this.detail.getParent();
        }
        return this.parent;
    }

    public String getName() throws Exception {
        return this.detail.getName();
    }

    public Class getType() {
        return this.type;
    }

    public Contact getContact() {
        return this.detail.getContact();
    }

    public String getOverride() {
        return this.name;
    }

    public boolean isData() {
        return this.label.data();
    }

    public boolean isRequired() {
        return this.label.required();
    }

    public boolean isInline() {
        return this.label.inline();
    }

    public String getEmpty() {
        return null;
    }

    public String toString() {
        return this.detail.toString();
    }
}

