/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.simpleframework.common.thread.ConcurrentScheduler;
import org.simpleframework.common.thread.Scheduler;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.socket.service.FrameCollector;
import org.simpleframework.http.socket.service.Router;
import org.simpleframework.http.socket.service.SessionBuilder;
import org.simpleframework.http.socket.service.SessionDispatcher;
import org.simpleframework.transport.reactor.ExecutorReactor;
import org.simpleframework.transport.reactor.Reactor;

class ServiceDispatcher {
    private final SessionDispatcher dispatcher;
    private final SessionBuilder builder;
    private final Scheduler scheduler;
    private final Reactor reactor;

    public ServiceDispatcher(Router router, int threads) throws IOException {
        this(router, threads, 10000L);
    }

    public ServiceDispatcher(Router router, int threads, long ping) throws IOException {
        this.scheduler = new ConcurrentScheduler(FrameCollector.class, threads);
        this.reactor = new ExecutorReactor((Executor)this.scheduler);
        this.builder = new SessionBuilder(this.scheduler, this.reactor, ping);
        this.dispatcher = new SessionDispatcher(this.builder, router);
    }

    public void dispatch(Request request, Response response) {
        this.dispatcher.dispatch(request, response);
    }
}

