/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import java.io.IOException;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.socket.CloseCode;
import org.simpleframework.http.socket.Frame;
import org.simpleframework.http.socket.FrameChannel;
import org.simpleframework.http.socket.FrameListener;
import org.simpleframework.http.socket.Reason;
import org.simpleframework.http.socket.Session;
import org.simpleframework.http.socket.service.FrameCollector;
import org.simpleframework.http.socket.service.FrameEncoder;
import org.simpleframework.http.socket.service.ServiceEvent;
import org.simpleframework.http.socket.service.ServiceSession;
import org.simpleframework.transport.ByteWriter;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.reactor.Reactor;
import org.simpleframework.transport.trace.Trace;

class FrameConnection
implements FrameChannel {
    private final FrameCollector operation;
    private final FrameEncoder encoder;
    private final ByteWriter writer;
    private final Session session;
    private final Channel channel;
    private final Reason reason;
    private final Trace trace;

    public FrameConnection(Request request, Response response, Reactor reactor) {
        this.encoder = new FrameEncoder(request);
        this.session = new ServiceSession(this, request, response);
        this.operation = new FrameCollector(this.encoder, this.session, request, reactor);
        this.reason = new Reason(CloseCode.NORMAL_CLOSURE);
        this.channel = request.getChannel();
        this.writer = this.channel.getWriter();
        this.trace = this.channel.getTrace();
    }

    public Session open() throws IOException {
        this.trace.trace((Object)ServiceEvent.OPEN_SOCKET);
        this.operation.run();
        return this.session;
    }

    public void register(FrameListener listener) throws IOException {
        this.operation.register(listener);
    }

    public void remove(FrameListener listener) throws IOException {
        this.operation.remove(listener);
    }

    public void send(byte[] data) throws IOException {
        this.encoder.encode(data);
    }

    public void send(String text) throws IOException {
        this.encoder.encode(text);
    }

    public void send(Frame frame) throws IOException {
        this.encoder.encode(frame);
    }

    public void close(Reason reason) throws IOException {
        this.encoder.encode(reason);
        this.writer.close();
    }

    public void close() throws IOException {
        this.encoder.encode(this.reason);
        this.writer.close();
    }
}

