/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import java.nio.channels.SelectableChannel;
import org.simpleframework.http.Request;
import org.simpleframework.http.socket.FrameListener;
import org.simpleframework.http.socket.Session;
import org.simpleframework.http.socket.service.FrameEncoder;
import org.simpleframework.http.socket.service.FrameProcessor;
import org.simpleframework.http.socket.service.ServiceEvent;
import org.simpleframework.transport.ByteCursor;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.transport.reactor.Reactor;
import org.simpleframework.transport.trace.Trace;

class FrameCollector
implements Operation {
    private final FrameProcessor processor;
    private final ByteCursor cursor;
    private final Channel channel;
    private final Reactor reactor;
    private final Trace trace;

    public FrameCollector(FrameEncoder encoder, Session session, Request request, Reactor reactor) {
        this.processor = new FrameProcessor(encoder, session, request);
        this.channel = request.getChannel();
        this.cursor = this.channel.getCursor();
        this.trace = this.channel.getTrace();
        this.reactor = reactor;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public SelectableChannel getChannel() {
        return this.channel.getSocket();
    }

    public void register(FrameListener listener) {
        this.processor.register(listener);
    }

    public void remove(FrameListener listener) {
        this.processor.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.processor.process();
            if (this.cursor.isOpen()) {
                this.reactor.process((Operation)this, 1);
            } else {
                this.processor.close();
            }
        }
        catch (Exception cause) {
            this.trace.trace((Object)ServiceEvent.ERROR, (Object)cause);
            try {
                this.processor.failure(cause);
            }
            catch (Exception fatal) {
                this.trace.trace((Object)ServiceEvent.ERROR, (Object)fatal);
            }
            finally {
                this.channel.close();
            }
        }
    }

    public void cancel() {
        try {
            this.processor.close();
        }
        catch (Exception cause) {
            this.trace.trace((Object)ServiceEvent.ERROR, (Object)cause);
            this.channel.close();
        }
    }
}

