/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.socket.service.Router;
import org.simpleframework.http.socket.service.Service;

public class DirectRouter
implements Router {
    private final Service service;
    private final String protocol;

    public DirectRouter(Service service) {
        this(service, null);
    }

    public DirectRouter(Service service, String protocol) {
        this.protocol = protocol;
        this.service = service;
    }

    public Service route(Request request, Response response) {
        String token = request.getValue("Upgrade");
        if (token != null && token.equalsIgnoreCase("websocket")) {
            String version = request.getValue("Sec-WebSocket-Version");
            if (version != null) {
                response.setValue("Sec-WebSocket-Version", version);
            }
            if (this.protocol != null) {
                response.setValue("Sec-WebSocket-Protocol", this.protocol);
            }
            return this.service;
        }
        return null;
    }
}

