/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.util.concurrent.Future;
import javax.security.cert.X509Certificate;
import org.simpleframework.http.core.BodyObserver;
import org.simpleframework.http.message.Entity;
import org.simpleframework.transport.Certificate;
import org.simpleframework.transport.CertificateChallenge;
import org.simpleframework.transport.Channel;

class RequestCertificate
implements Certificate {
    private final CertificateChallenge challenge;
    private final Certificate certificate;
    private final Channel channel;

    public RequestCertificate(BodyObserver observer, Entity entity) {
        this.challenge = new Challenge(observer, entity);
        this.channel = entity.getChannel();
        this.certificate = this.channel.getCertificate();
    }

    public X509Certificate[] getChain() throws Exception {
        return this.certificate.getChain();
    }

    public CertificateChallenge getChallenge() throws Exception {
        return this.challenge;
    }

    public boolean isChainPresent() throws Exception {
        return this.certificate.isChainPresent();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Challenge
    implements CertificateChallenge {
        private final BodyObserver observer;
        private final Certificate certificate;
        private final Channel channel;

        public Challenge(BodyObserver observer, Entity entity) {
            this.channel = entity.getChannel();
            this.certificate = this.channel.getCertificate();
            this.observer = observer;
        }

        public Future<Certificate> challenge() throws Exception {
            return this.challenge(null);
        }

        public Future<Certificate> challenge(Runnable completion) throws Exception {
            if (this.certificate == null) {
                throw new IOException("Challenging must be done on a secure connection");
            }
            CertificateChallenge challenge = this.certificate.getChallenge();
            if (this.certificate.isChainPresent()) {
                throw new IOException("Certificate is already present");
            }
            if (this.observer.isCommitted()) {
                throw new IOException("Response has already been committed");
            }
            return challenge.challenge(completion);
        }
    }
}

