/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.common.buffer;

import java.io.IOException;
import org.simpleframework.common.buffer.Allocator;
import org.simpleframework.common.buffer.Buffer;
import org.simpleframework.common.buffer.BufferException;

public class FilterAllocator
implements Allocator {
    protected Allocator source;
    protected long capacity;
    protected long limit;

    public FilterAllocator(Allocator source) {
        this(source, 512L, 0x100000L);
    }

    public FilterAllocator(Allocator source, long capacity) {
        this(source, capacity, 0x100000L);
    }

    public FilterAllocator(Allocator source, long capacity, long limit) {
        this.limit = Math.max(capacity, limit);
        this.capacity = capacity;
        this.source = source;
    }

    public Buffer allocate() throws IOException {
        return this.allocate(this.capacity);
    }

    public Buffer allocate(long size) throws IOException {
        if (size > this.limit) {
            throw new BufferException("Specified size %s beyond limit", size);
        }
        if (this.capacity > size) {
            size = this.capacity;
        }
        return this.source.allocate(size);
    }
}

