/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.simpleflatmapper.util.Predicate;

public final class TypeHelper {
    private static final Map<Class<?>, Class<?>> wrappers = new HashMap();

    private TypeHelper() {
    }

    public static <T> Class<T> toClass(Type target) {
        if (target instanceof Class) {
            return (Class)target;
        }
        if (target instanceof ParameterizedType) {
            return TypeHelper.toClass(((ParameterizedType)target).getRawType());
        }
        if (target instanceof TypeVariable) {
            return TypeHelper.toClass(((TypeVariable)target).getBounds()[0]);
        }
        if (target instanceof WildcardType) {
            return TypeHelper.toClass(((WildcardType)target).getUpperBounds()[0]);
        }
        if (target instanceof GenericArrayType) {
            return Array.newInstance(TypeHelper.toClass(((GenericArrayType)target).getGenericComponentType()), 0).getClass();
        }
        throw new UnsupportedOperationException("Cannot extract class from type " + target + " " + target.getClass());
    }

    public static ClassLoader getClassLoader(Type target, ClassLoader defaultClassLoader) {
        if (target == null) {
            return defaultClassLoader;
        }
        Class clazz = TypeHelper.toClass(target);
        if (clazz == null) {
            return defaultClassLoader;
        }
        return clazz.getClassLoader();
    }

    public static <T> Map<TypeVariable<?>, Type> getTypesMap(Type targetType) {
        Class<T> targetClass = TypeHelper.toClass(targetType);
        Map<TypeVariable<?>, Type> genericTypes = Collections.emptyMap();
        if (targetType instanceof ParameterizedType) {
            TypeVariable<Class<T>>[] typeParameters = targetClass.getTypeParameters();
            Type[] actualTypeArguments = ((ParameterizedType)targetType).getActualTypeArguments();
            genericTypes = new HashMap();
            for (int i = 0; i < typeParameters.length; ++i) {
                TypeVariable<Class<T>> typeParameter = typeParameters[i];
                Type typeArgument = actualTypeArguments[i];
                genericTypes.put(typeParameter, typeArgument);
            }
        }
        return genericTypes;
    }

    public static boolean isPrimitive(Type type) {
        return TypeHelper.toClass(type).isPrimitive();
    }

    public static Class<?> wrap(Class<?> target) {
        if (target.isPrimitive()) {
            return wrappers.get(target);
        }
        return target;
    }

    public static boolean areCompatible(Class<?> target, Class<?> source) {
        Class<?> wrapTarget = TypeHelper.wrap(target);
        Class<?> wrapSource = TypeHelper.wrap(source);
        return wrapTarget.isAssignableFrom(wrapSource);
    }

    public static boolean isNumber(Type target) {
        return Number.class.isAssignableFrom(TypeHelper.wrap(TypeHelper.toClass(target)));
    }

    public static boolean isArray(Type outType) {
        return TypeHelper.toClass(outType).isArray();
    }

    public static Type getComponentTypeOfListOrArray(Type outType) {
        Type parameterType;
        Class target = TypeHelper.toClass(outType);
        if (target.isArray()) {
            return TypeHelper.toClass(outType).getComponentType();
        }
        Type[] parameterTypes = TypeHelper.getGenericParameterForClass(outType, Iterable.class);
        if (parameterTypes != null && (parameterType = parameterTypes[0]) != null) {
            return parameterType;
        }
        return Object.class;
    }

    public static MapEntryTypes getKeyValueTypeOfMap(Type outType) {
        Type[] parameterTypes = TypeHelper.getGenericParameterForClass(outType, Map.class);
        if (parameterTypes != null) {
            return new MapEntryTypes(parameterTypes[0], parameterTypes[1]);
        }
        return MapEntryTypes.OBJECT_OBJECT;
    }

    private static Type getGenericInterface(Type t, Class<?> i) {
        if (TypeHelper.areEquals(t, i)) {
            return t;
        }
        for (Type it : TypeHelper.toClass(t).getGenericInterfaces()) {
            if (!TypeHelper.isAssignable(i, it)) continue;
            if (TypeHelper.areEquals(it, i)) {
                return it;
            }
            return TypeHelper.getGenericInterface(it, i);
        }
        return null;
    }

    private static Type getGenericSuperType(Type t) {
        return TypeHelper.toClass(t).getGenericSuperclass();
    }

    public static boolean isAssignable(Type type, Type from) {
        return TypeHelper.isAssignable(TypeHelper.toBoxedClass(type), from);
    }

    public static boolean isAssignable(Class<?> class1, Type from) {
        return class1.isAssignableFrom(TypeHelper.toBoxedClass(from));
    }

    public static boolean isJavaLang(Type target) {
        Class clazz = TypeHelper.toClass(target);
        return clazz.isPrimitive() || clazz.getPackage() != null && clazz.getPackage().getName().equals("java.lang");
    }

    public static boolean isInPackage(Type target, Predicate<String> packagePredicate) {
        Class clazz = TypeHelper.toClass(target);
        Package clazzPackage = clazz.getPackage();
        if (clazzPackage != null) {
            return packagePredicate.test(clazzPackage.getName());
        }
        return false;
    }

    public static boolean isEnum(Type target) {
        Class clazz = TypeHelper.toClass(target);
        return clazz.isEnum();
    }

    public static Class<?> toBoxedClass(Type type) {
        return TypeHelper.toBoxedClass(TypeHelper.toClass(type));
    }

    public static Class<?> toBoxedClass(Class<?> target) {
        if (target.isPrimitive()) {
            Class<?> clazz = wrappers.get(target);
            if (clazz == null) {
                throw new RuntimeException("Unexpected primitive type " + target);
            }
            return clazz;
        }
        return target;
    }

    public static boolean areEquals(Type target, Type clazz) {
        return TypeHelper.toClass(clazz).equals(TypeHelper.toClass(target));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Type[] getGenericParameterForClass(Type type, Class<?> interfaceClass) {
        Type[] types;
        if (!TypeHelper.isAssignable(interfaceClass, type)) throw new IllegalArgumentException("type " + type + " does not implement/extends " + interfaceClass);
        Type genericInterface = TypeHelper.getGenericInterface(type, interfaceClass);
        if (genericInterface != null) {
            if (!(genericInterface instanceof ParameterizedType)) return null;
            types = ((ParameterizedType)genericInterface).getActualTypeArguments();
        } else {
            types = TypeHelper.getGenericParameterForClass(TypeHelper.getGenericSuperType(type), interfaceClass);
        }
        TypeHelper.resolveTypeVariables(type, types);
        return types;
    }

    public static void resolveTypeVariables(Type source, Type[] types) {
        for (int i = 0; i < types.length; ++i) {
            Type t = types[i];
            if (!(t instanceof TypeVariable)) continue;
            types[i] = TypeHelper.resolveTypeVariable(source, (TypeVariable)t);
        }
    }

    public static Type resolveTypeVariable(Type type, TypeVariable t) {
        TypeVariable<Class<T>>[] typeParameters = TypeHelper.toClass(type).getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            TypeVariable typeVariable = typeParameters[i];
            if (!typeVariable.getName().equals(t.getName())) continue;
            if (type instanceof ParameterizedType) {
                return ((ParameterizedType)type).getActualTypeArguments()[i];
            }
            return Object.class;
        }
        return type;
    }

    public static boolean isKotlinClass(Type target) {
        Annotation[] annotations = TypeHelper.toClass(target).getDeclaredAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.length; ++i) {
                Annotation a = annotations[i];
                if (!a.annotationType().getName().equals("kotlin.Metadata")) continue;
                return true;
            }
        }
        return false;
    }

    static {
        wrappers.put(Boolean.TYPE, Boolean.class);
        wrappers.put(Byte.TYPE, Byte.class);
        wrappers.put(Short.TYPE, Short.class);
        wrappers.put(Character.TYPE, Character.class);
        wrappers.put(Integer.TYPE, Integer.class);
        wrappers.put(Long.TYPE, Long.class);
        wrappers.put(Float.TYPE, Float.class);
        wrappers.put(Double.TYPE, Double.class);
        wrappers.put(Void.TYPE, Void.class);
    }

    public static class MapEntryTypes {
        public static final MapEntryTypes OBJECT_OBJECT = new MapEntryTypes((Type)((Object)Object.class), (Type)((Object)Object.class));
        private final Type keyType;
        private final Type valueType;

        public MapEntryTypes(Type keyType, Type valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public Type getKeyType() {
            return this.keyType;
        }

        public Type getValueType() {
            return this.valueType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapEntryTypes that = (MapEntryTypes)o;
            if (this.keyType != null ? !this.keyType.equals(that.keyType) : that.keyType != null) {
                return false;
            }
            return this.valueType != null ? this.valueType.equals(that.valueType) : that.valueType == null;
        }

        public int hashCode() {
            int result = this.keyType != null ? this.keyType.hashCode() : 0;
            result = 31 * result + (this.valueType != null ? this.valueType.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "MapEntryTypes{keyType=" + this.keyType + ", valueType=" + this.valueType + '}';
        }
    }
}

