/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.sfm.map.MapperBuildingException;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.reflect.meta.PropertyFinder;
import org.sfm.reflect.meta.TuplePropertyFinder;
import org.sfm.tuples.Tuples;
import org.sfm.utils.ErrorHelper;

public class TupleClassMeta<T>
implements ClassMeta<T> {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final ReflectionService reflectionService;
    private final Type type;
    private final InstantiatorDefinition instantiatorDefinition;

    public TupleClassMeta(Type type, ReflectionService reflectionService) {
        this.type = type;
        this.reflectionService = reflectionService;
        try {
            this.instantiatorDefinition = this.getInstantiatorDefinition(type, reflectionService);
        }
        catch (Exception e) {
            ErrorHelper.rethrow(e);
            throw new IllegalStateException();
        }
    }

    private InstantiatorDefinition getInstantiatorDefinition(Type type, ReflectionService reflectionService) throws IOException {
        List<InstantiatorDefinition> definitions = reflectionService.extractConstructors(type);
        ListIterator<InstantiatorDefinition> iterator = definitions.listIterator();
        while (iterator.hasNext()) {
            InstantiatorDefinition definition = iterator.next();
            if (!this.isTupleConstructor(type, definition)) continue;
            return this.respecifyParameterNames(definition);
        }
        throw new MapperBuildingException("Cannot find eligible constructor definition for " + type);
    }

    private InstantiatorDefinition respecifyParameterNames(InstantiatorDefinition definition) {
        Parameter[] parameters = definition.getParameters();
        if (parameters.length > 0 && parameters[0].getName().equals("arg0")) {
            Parameter[] newParams = new Parameter[parameters.length];
            ElementNameGenerator nameGenerator = TupleClassMeta.elementNameGenerator(definition.getExecutable().getDeclaringClass());
            for (int i = 0; i < parameters.length; ++i) {
                newParams[i] = new Parameter(nameGenerator.name(i), parameters[i].getType(), parameters[i].getGenericType());
            }
            return new InstantiatorDefinition((Constructor)definition.getExecutable(), newParams);
        }
        return definition;
    }

    private boolean isTupleConstructor(Type type, InstantiatorDefinition definition) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return pt.getActualTypeArguments().length == definition.getParameters().length;
        }
        return true;
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.reflectionService;
    }

    @Override
    public PropertyFinder<T> newPropertyFinder() {
        return new TuplePropertyFinder(this);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public String[] generateHeaders() {
        ArrayList<String> strings = new ArrayList<String>();
        SFMTupleNameGenerator nameGenerator = new SFMTupleNameGenerator();
        int i = 0;
        for (Parameter cp : this.instantiatorDefinition.getParameters()) {
            String prefix = nameGenerator.name(i);
            ClassMeta classMeta = this.reflectionService.getClassMeta(cp.getGenericType());
            for (String prop : classMeta.generateHeaders()) {
                String name = prop.length() == 0 ? prefix : prefix + "_" + prop;
                strings.add(name);
            }
            ++i;
        }
        return strings.toArray(EMPTY_STRING_ARRAY);
    }

    private static ElementNameGenerator elementNameGenerator(Type type) {
        Class clazz = TypeHelper.toClass(type);
        if (Tuples.isJoolTuple(clazz)) {
            return new JoolTupleNameGenerator();
        }
        return new SFMTupleNameGenerator();
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        return Arrays.asList(this.instantiatorDefinition);
    }

    public int getTupleSize() {
        return this.instantiatorDefinition.getParameters().length;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    static class JoolTupleNameGenerator
    implements ElementNameGenerator {
        JoolTupleNameGenerator() {
        }

        @Override
        public String name(int i) {
            return "v" + (i + 1);
        }
    }

    static class SFMTupleNameGenerator
    implements ElementNameGenerator {
        SFMTupleNameGenerator() {
        }

        @Override
        public String name(int i) {
            return "element" + i;
        }
    }

    static interface ElementNameGenerator {
        public String name(int var1);
    }
}

