/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.lang.reflect.Type;
import org.sfm.reflect.Getter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.Setter;
import org.sfm.reflect.meta.ClassMeta;

public abstract class PropertyMeta<O, P> {
    private final String name;
    protected final ReflectionService reflectService;
    private volatile Setter<O, P> setter;
    private volatile Getter<O, P> getter;
    private volatile ClassMeta<P> classMeta;

    public PropertyMeta(String name, ReflectionService reflectService) {
        this.name = name;
        this.reflectService = reflectService;
    }

    public final Setter<O, P> getSetter() {
        Setter<O, P> lSetter = this.setter;
        if (lSetter == null) {
            this.setter = lSetter = this.newSetter();
        }
        return lSetter;
    }

    public final Getter<O, P> getGetter() {
        Getter<O, P> lGetter = this.getter;
        if (lGetter == null) {
            this.getter = lGetter = this.newGetter();
        }
        return lGetter;
    }

    protected abstract Setter<O, P> newSetter();

    protected abstract Getter<O, P> newGetter();

    public final String getName() {
        return this.name;
    }

    public abstract Type getPropertyType();

    public final ClassMeta<P> getPropertyClassMeta() {
        ClassMeta<P> meta = this.classMeta;
        if (meta == null) {
            this.classMeta = meta = this.newPropertyClassMeta();
        }
        return meta;
    }

    protected ClassMeta<P> newPropertyClassMeta() {
        return this.reflectService.getClassMeta(this.getPropertyType());
    }

    public boolean isConstructorProperty() {
        return false;
    }

    public abstract String getPath();

    public boolean isSubProperty() {
        return false;
    }
}

