/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.sfm.map.MapperBuildingException;
import org.sfm.reflect.InstantiatorDefinition;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.meta.ConstructorPropertyMeta;
import org.sfm.reflect.meta.ObjectClassMeta;
import org.sfm.reflect.meta.PropertyFinder;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.reflect.meta.PropertyNameMatcher;
import org.sfm.reflect.meta.SubPropertyMeta;

final class ObjectPropertyFinder<T>
implements PropertyFinder<T> {
    private final List<InstantiatorDefinition> eligibleInstantiatorDefinitions;
    private final ObjectClassMeta<T> classMeta;
    private final Map<String, PropertyFinder<?>> subPropertyFinders = new HashMap();

    ObjectPropertyFinder(ObjectClassMeta<T> classMeta) throws MapperBuildingException {
        this.classMeta = classMeta;
        this.eligibleInstantiatorDefinitions = classMeta.getInstantiatorDefinitions() != null ? new ArrayList<InstantiatorDefinition>(classMeta.getInstantiatorDefinitions()) : null;
    }

    @Override
    public <E> PropertyMeta<T, E> findProperty(PropertyNameMatcher propertyNameMatcher) {
        PropertyMeta prop = this.lookForConstructor(propertyNameMatcher);
        if (prop == null) {
            prop = this.lookForProperty(propertyNameMatcher);
            if (prop == null) {
                prop = this.lookForSubPropertyInConstructors(propertyNameMatcher);
                if (prop == null) {
                    prop = this.lookForSubProperty(propertyNameMatcher);
                } else {
                    ConstructorPropertyMeta constructorProperty = (ConstructorPropertyMeta)((SubPropertyMeta)prop).getOwnerProperty();
                    this.removeNonMatching(constructorProperty.getParameter());
                }
            }
        } else {
            ConstructorPropertyMeta<T, ?> constructorProperty = prop;
            this.removeNonMatching(constructorProperty.getParameter());
        }
        return prop;
    }

    private ConstructorPropertyMeta<T, ?> lookForConstructor(PropertyNameMatcher propertyNameMatcher) {
        if (this.classMeta.getConstructorProperties() != null) {
            for (ConstructorPropertyMeta<T, ?> prop : this.classMeta.getConstructorProperties()) {
                if (!propertyNameMatcher.matches(this.getColumnName(prop)) || !this.hasConstructorMatching(prop.getParameter())) continue;
                return prop;
            }
        }
        return null;
    }

    private PropertyMeta<T, ?> lookForProperty(PropertyNameMatcher propertyNameMatcher) {
        for (PropertyMeta<T, ?> prop : this.classMeta.getProperties()) {
            if (!propertyNameMatcher.matches(this.getColumnName(prop))) continue;
            return prop;
        }
        return null;
    }

    private PropertyMeta<T, ?> lookForSubPropertyInConstructors(PropertyNameMatcher propertyNameMatcher) {
        if (this.classMeta.getConstructorProperties() != null) {
            for (ConstructorPropertyMeta<T, ?> prop : this.classMeta.getConstructorProperties()) {
                PropertyMeta<?, ?> subProp;
                PropertyNameMatcher subPropMatcher = propertyNameMatcher.partialMatch(this.getColumnName(prop));
                if (subPropMatcher == null || !this.hasConstructorMatching(prop.getParameter()) || (subProp = this.lookForSubProperty(subPropMatcher, prop)) == null) continue;
                return new SubPropertyMeta(this.classMeta.getReflectionService(), prop, subProp);
            }
        }
        return null;
    }

    private PropertyMeta<T, ?> lookForSubProperty(PropertyNameMatcher propertyNameMatcher) {
        for (PropertyMeta<T, ?> prop : this.classMeta.getProperties()) {
            PropertyMeta<?, ?> subProp;
            PropertyNameMatcher subPropMatcher = propertyNameMatcher.partialMatch(this.getColumnName(prop));
            if (subPropMatcher == null || (subProp = this.lookForSubProperty(subPropMatcher, prop)) == null) continue;
            return new SubPropertyMeta(this.classMeta.getReflectionService(), prop, subProp);
        }
        return null;
    }

    private PropertyMeta<?, ?> lookForSubProperty(PropertyNameMatcher propertyNameMatcher, PropertyMeta<T, ?> prop) {
        PropertyFinder<?> subPropertyFinder = this.subPropertyFinders.get(this.getColumnName(prop));
        if (subPropertyFinder == null) {
            subPropertyFinder = prop.getPropertyClassMeta().newPropertyFinder();
            this.subPropertyFinders.put(prop.getName(), subPropertyFinder);
        }
        return subPropertyFinder.findProperty(propertyNameMatcher);
    }

    private String getColumnName(PropertyMeta<T, ?> prop) {
        return this.classMeta.getAlias(prop.getName());
    }

    private void removeNonMatching(Parameter param) {
        ListIterator<InstantiatorDefinition> li = this.eligibleInstantiatorDefinitions.listIterator();
        while (li.hasNext()) {
            InstantiatorDefinition cd = li.next();
            if (cd.hasParam(param)) continue;
            li.remove();
        }
    }

    private boolean hasConstructorMatching(Parameter param) {
        for (InstantiatorDefinition cd : this.eligibleInstantiatorDefinitions) {
            if (!cd.hasParam(param)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return this.eligibleInstantiatorDefinitions;
    }
}

