/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.sfm.reflect.Getter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.Setter;
import org.sfm.reflect.SetterHelper;
import org.sfm.reflect.meta.PropertyMeta;

public class MethodPropertyMeta<T, P>
extends PropertyMeta<T, P> {
    private final Method setter;
    private final Method getter;
    private final Type type;

    public MethodPropertyMeta(String name, ReflectionService reflectService, Method method, Type type) {
        super(name, reflectService);
        this.setter = method;
        this.type = type;
        this.getter = null;
    }

    public MethodPropertyMeta(String name, ReflectionService reflectService, Method setter, Method getter, Type type) {
        super(name, reflectService);
        this.setter = setter;
        this.getter = getter;
        this.type = type;
    }

    @Override
    protected Setter<T, P> newSetter() {
        return this.reflectService.getObjectSetterFactory().getMethodSetter(this.setter);
    }

    @Override
    protected Getter<T, P> newGetter() {
        if (this.getter == null) {
            return this.reflectService.getObjectGetterFactory().getGetter(this.setter.getDeclaringClass(), SetterHelper.getPropertyNameFromMethodName(this.setter.getName()));
        }
        return this.reflectService.getObjectGetterFactory().getMethodGetter(this.getter);
    }

    @Override
    public Type getPropertyType() {
        return this.type;
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    public String toString() {
        return "MethodPropertyMeta{setter=" + this.setter + ", getter=" + this.getter + ", type=" + this.type + '}';
    }
}

