/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.reflect.meta;

import java.lang.reflect.Type;
import org.sfm.reflect.Getter;
import org.sfm.reflect.Parameter;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.Setter;
import org.sfm.reflect.impl.NullGetter;
import org.sfm.reflect.impl.NullSetter;
import org.sfm.reflect.meta.PropertyMeta;

public class ConstructorPropertyMeta<T, P>
extends PropertyMeta<T, P> {
    private final Class<T> owner;
    private final Parameter parameter;

    public ConstructorPropertyMeta(String name, ReflectionService reflectService, Parameter parameter, Class<T> owner) {
        super(name, reflectService);
        this.parameter = parameter;
        this.owner = owner;
    }

    @Override
    protected Setter<T, P> newSetter() {
        return new NullSetter();
    }

    @Override
    protected Getter<T, P> newGetter() {
        Getter getter = this.reflectService.getObjectGetterFactory().getGetter(this.owner, this.getName());
        if (getter == null) {
            return new NullGetter();
        }
        return getter;
    }

    @Override
    public Type getPropertyType() {
        return this.parameter.getGenericType();
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public boolean isConstructorProperty() {
        return true;
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    public String toString() {
        return "ConstructorPropertyMeta{owner=" + this.owner + ", constructorParameter=" + this.parameter + '}';
    }
}

