/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.impl.getter.time;

import java.time.Instant;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.sfm.reflect.Getter;

public class JavaYearMonthFromObjectGetter<S>
implements Getter<S, YearMonth> {
    private final Getter<S, ?> getter;
    private final ZoneId zone;

    public JavaYearMonthFromObjectGetter(Getter<S, ?> getter, ZoneId zoneId) {
        this.getter = getter;
        this.zone = zoneId;
    }

    @Override
    public YearMonth get(S target) throws Exception {
        Object o = this.getter.get(target);
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            ZonedDateTime dateTime = Instant.ofEpochMilli(((Date)o).getTime()).atZone(this.zone);
            return YearMonth.of(dateTime.getYear(), dateTime.getMonth());
        }
        if (o instanceof Integer || o instanceof Long) {
            int l = ((Number)o).intValue();
            int year = l / 100;
            int month = l % 100;
            return YearMonth.of(year, month);
        }
        if (o instanceof TemporalAccessor) {
            return YearMonth.from((TemporalAccessor)o);
        }
        throw new IllegalArgumentException("Cannot convert " + o + " to YearMonth");
    }

    public String toString() {
        return "JavaYearMonthFromObjectGetter{getter=" + this.getter + '}';
    }
}

