/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.impl.getter.time;

import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import org.sfm.map.ColumnDefinition;
import org.sfm.map.FieldKey;
import org.sfm.map.GetterFactory;
import org.sfm.map.column.time.JavaTimeHelper;
import org.sfm.map.impl.getter.time.JavaInstantFromObjectGetter;
import org.sfm.map.impl.getter.time.JavaLocalDateFromObjectGetter;
import org.sfm.map.impl.getter.time.JavaLocalDateTimeFromObjectGetter;
import org.sfm.map.impl.getter.time.JavaLocalTimeFromObjectGetter;
import org.sfm.map.impl.getter.time.JavaOffsetDateTimeFromObjectGetter;
import org.sfm.map.impl.getter.time.JavaOffsetTimeFromObjectGetter;
import org.sfm.map.impl.getter.time.JavaYearFromObjectGetter;
import org.sfm.map.impl.getter.time.JavaYearMonthFromObjectGetter;
import org.sfm.map.impl.getter.time.JavaZonedDateTimeFromObjectGetter;
import org.sfm.reflect.Getter;
import org.sfm.reflect.TypeHelper;
import org.sfm.utils.Asserts;

public class JavaTimeGetterFactory<T, K extends FieldKey<K>>
implements GetterFactory<T, K> {
    private final GetterFactory<T, K> getterFactory;

    public JavaTimeGetterFactory(GetterFactory<T, K> getterFactory) {
        Asserts.requireNonNull("getterFactory", getterFactory);
        this.getterFactory = getterFactory;
    }

    @Override
    public <P> Getter<T, P> newGetter(Type target, K key, ColumnDefinition<?, ?> columnDefinition) {
        Class clazz = TypeHelper.toClass(target);
        Getter getter = this.getterFactory.newGetter((Type)((Object)Object.class), key, columnDefinition);
        if (Instant.class.equals(clazz)) {
            return new JavaInstantFromObjectGetter<T>(getter);
        }
        if (LocalDate.class.equals(clazz)) {
            return new JavaLocalDateFromObjectGetter<T>(getter, JavaTimeHelper.getZoneIdOrDefault(columnDefinition));
        }
        if (LocalDateTime.class.equals(clazz)) {
            return new JavaLocalDateTimeFromObjectGetter<T>(getter, JavaTimeHelper.getZoneIdOrDefault(columnDefinition));
        }
        if (LocalTime.class.equals(clazz)) {
            return new JavaLocalTimeFromObjectGetter<T>(getter, JavaTimeHelper.getZoneIdOrDefault(columnDefinition));
        }
        if (OffsetDateTime.class.equals(clazz)) {
            return new JavaOffsetDateTimeFromObjectGetter<T>(getter, JavaTimeHelper.getZoneIdOrDefault(columnDefinition));
        }
        if (OffsetTime.class.equals(clazz)) {
            return new JavaOffsetTimeFromObjectGetter<T>(getter, JavaTimeHelper.getZoneIdOrDefault(columnDefinition));
        }
        if (Year.class.equals(clazz)) {
            return new JavaYearFromObjectGetter<T>(getter, JavaTimeHelper.getZoneIdOrDefault(columnDefinition));
        }
        if (YearMonth.class.equals(clazz)) {
            return new JavaYearMonthFromObjectGetter<T>(getter, JavaTimeHelper.getZoneIdOrDefault(columnDefinition));
        }
        if (ZonedDateTime.class.equals(clazz)) {
            return new JavaZonedDateTimeFromObjectGetter<T>(getter, JavaTimeHelper.getZoneIdOrDefault(columnDefinition));
        }
        return null;
    }
}

