/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.impl.fieldmapper;

import org.sfm.map.FieldMapper;
import org.sfm.map.Mapper;
import org.sfm.map.MappingContext;
import org.sfm.reflect.Getter;
import org.sfm.reflect.Setter;
import org.sfm.utils.Asserts;
import org.sfm.utils.BooleanProvider;
import org.sfm.utils.Predicate;

public final class MapperFieldMapper<S, T, P>
implements FieldMapper<S, T> {
    private final Mapper<S, P> mapper;
    private final Setter<T, P> propertySetter;
    private final Getter<T, P> propertyGetter;
    private final Predicate<S> nullChecker;
    private final Getter<MappingContext<? super S>, BooleanProvider> breakDetectorProvider;

    public MapperFieldMapper(Mapper<S, P> mapper, Setter<T, P> propertySetter, Getter<T, P> propertyGetter, Predicate<S> nullChecker, Getter<MappingContext<? super S>, BooleanProvider> breakDetectorProvider) {
        this.mapper = Asserts.requireNonNull("jdbcMapper", mapper);
        this.propertySetter = Asserts.requireNonNull("propertySetter", propertySetter);
        this.propertyGetter = Asserts.requireNonNull("propertyGetter", propertyGetter);
        this.nullChecker = Asserts.requireNonNull("nullChecker", nullChecker);
        this.breakDetectorProvider = Asserts.requireNonNull("breakDetectorProvider", breakDetectorProvider);
    }

    @Override
    public void mapTo(S source, T target, MappingContext<? super S> context) throws Exception {
        if (this.nullChecker.test(source)) {
            return;
        }
        boolean isBroken = this.breakDetectorProvider.get(context).getBoolean();
        if (isBroken) {
            this.propertySetter.set(target, this.mapper.map((S)source, context));
        } else {
            P value = this.propertyGetter.get(target);
            if (value != null) {
                this.mapper.mapTo((S)source, value, context);
            }
        }
    }

    public String toString() {
        return "MapperFieldMapper{jdbcMapper=" + this.mapper + ", propertySetter=" + this.propertySetter + ", propertyGetter=" + this.propertyGetter + '}';
    }
}

