/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.impl.context;

import java.util.ArrayList;
import java.util.List;
import org.sfm.map.MappingContext;
import org.sfm.map.MappingContextFactory;
import org.sfm.map.impl.context.BreakDetectorMappingContextFactory;
import org.sfm.map.impl.context.BreakGetter;
import org.sfm.map.impl.context.KeySourceGetter;
import org.sfm.map.impl.context.KeysDefinition;
import org.sfm.map.impl.context.NullChecker;
import org.sfm.map.impl.context.RootBreakGetterProvider;
import org.sfm.map.impl.context.ValuedMapperContextFactory;
import org.sfm.reflect.Getter;
import org.sfm.reflect.meta.ListElementPropertyMeta;
import org.sfm.reflect.meta.MapElementPropertyMeta;
import org.sfm.reflect.meta.PropertyMeta;
import org.sfm.utils.BooleanProvider;
import org.sfm.utils.Predicate;
import org.sfm.utils.Supplier;

public class MappingContextFactoryBuilder<S, K> {
    private final Counter counter;
    private final int currentIndex;
    private final MappingContextFactoryBuilder<S, K> parent;
    private final List<K> keys;
    private final KeySourceGetter<K, S> keySourceGetter;
    private final List<MappingContextFactoryBuilder<S, K>> children = new ArrayList<MappingContextFactoryBuilder<S, K>>();
    private final List<Supplier<?>> suppliers = new ArrayList();
    private final PropertyMeta<?, ?> owner;

    public MappingContextFactoryBuilder(KeySourceGetter<K, S> keySourceGetter) {
        this(new Counter(), new ArrayList(), keySourceGetter, null, null);
    }

    protected MappingContextFactoryBuilder(Counter counter, List<K> keys, KeySourceGetter<K, S> keySourceGetter, MappingContextFactoryBuilder<S, K> parent, PropertyMeta<?, ?> owner) {
        this.counter = counter;
        this.currentIndex = counter.value;
        this.keys = keys;
        this.keySourceGetter = keySourceGetter;
        this.parent = parent;
        ++this.counter.value;
        this.owner = owner;
    }

    public void addKey(K key) {
        if (!this.keys.contains(key)) {
            this.keys.add(key);
        }
    }

    public void addSupplier(int index, Supplier<?> supplier) {
        while (this.suppliers.size() <= index) {
            this.suppliers.add(null);
        }
        this.suppliers.set(index, supplier);
    }

    public Predicate<S> nullChecker() {
        return new NullChecker<S, K>(this.keys, this.keySourceGetter);
    }

    public Getter<MappingContext<? super S>, BooleanProvider> breakDetectorGetter() {
        if (this.isEmpty()) {
            if (this.parent != null) {
                return this.parent.breakDetectorGetter();
            }
            return new RootBreakGetterProvider();
        }
        return new BreakGetter(this.currentIndex);
    }

    public MappingContextFactoryBuilder<S, K> newBuilder(List<K> subKeys, PropertyMeta<?, ?> owner) {
        MappingContextFactoryBuilder<S, K> subBuilder = new MappingContextFactoryBuilder<S, K>(this.counter, subKeys, this.keySourceGetter, this, owner);
        this.children.add(subBuilder);
        return subBuilder;
    }

    public MappingContextFactory<S> newFactory() {
        if (this.parent != null) {
            throw new IllegalStateException();
        }
        List<MappingContextFactoryBuilder<S, K>> builders = this.getAllBuilders();
        if (builders.isEmpty() && this.suppliers.isEmpty()) {
            return MappingContext.EMPTY_FACTORY;
        }
        if (!builders.isEmpty()) {
            KeysDefinition[] keyDefinions = new KeysDefinition[builders.get((int)(builders.size() - 1)).currentIndex + 1];
            int rootDetector = -1;
            for (int i = 0; i < builders.size(); ++i) {
                KeysDefinition<S, K> keyDefinition;
                MappingContextFactoryBuilder<S, K> builder = builders.get(i);
                keyDefinions[builder.currentIndex] = keyDefinition = super.newKeysDefinition(super.getParentNonEmptyIndex());
                if (builder.currentIndex != 0 && (rootDetector != -1 || !super.isEligibleAsRootKey())) continue;
                rootDetector = builder.currentIndex;
            }
            return new BreakDetectorMappingContextFactory(keyDefinions, rootDetector);
        }
        if (!this.suppliers.isEmpty()) {
            return new ValuedMapperContextFactory(this.suppliers);
        }
        throw new IllegalStateException();
    }

    private boolean isEligibleAsRootKey() {
        return !(this.owner instanceof ListElementPropertyMeta) && !(this.owner instanceof MapElementPropertyMeta) && (this.parent == null || super.isEligibleAsRootKey());
    }

    private int getParentNonEmptyIndex() {
        if (this.parent == null) {
            return -1;
        }
        if (this.parent.isEmpty()) {
            return super.getParentNonEmptyIndex();
        }
        return this.parent.currentIndex;
    }

    private KeysDefinition<S, K> newKeysDefinition(int parent) {
        return new KeysDefinition<S, K>(this.keys, this.keySourceGetter, parent);
    }

    private List<MappingContextFactoryBuilder<S, K>> getAllBuilders() {
        ArrayList<MappingContextFactoryBuilder<S, K>> list = new ArrayList<MappingContextFactoryBuilder<S, K>>();
        if (!this.isEmpty()) {
            list.add(this);
        }
        for (MappingContextFactoryBuilder<S, K> child : this.children) {
            list.addAll(super.getAllBuilders());
        }
        return list;
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    public boolean hasNoDependentKeys() {
        if (!this.isEmpty()) {
            return false;
        }
        for (MappingContextFactoryBuilder<S, K> builder : this.children) {
            if (builder.hasNoDependentKeys()) continue;
            return false;
        }
        return true;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean hasSuppliers() {
        return !this.suppliers.isEmpty();
    }

    public String toString() {
        return "MappingContextFactoryBuilder{currentIndex=" + this.currentIndex + ", keys=" + this.keys + ", children=" + this.children + '}';
    }

    private static class Counter {
        int value;

        private Counter() {
        }
    }
}

