/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.column.joda;

import java.util.TimeZone;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.sfm.map.ColumnDefinition;
import org.sfm.map.column.DateFormatProperty;
import org.sfm.map.column.TimeZoneProperty;
import org.sfm.map.column.joda.JodaDateTimeFormatterProperty;
import org.sfm.map.column.joda.JodaDateTimeZoneProperty;

public class JodaHelper {
    public static DateTimeFormatter getDateTimeFormatter(ColumnDefinition<?, ?> columnDefinition) {
        DateTimeFormatter dtf;
        if (columnDefinition.has(JodaDateTimeFormatterProperty.class)) {
            dtf = columnDefinition.lookFor(JodaDateTimeFormatterProperty.class).getFormatter();
        } else if (columnDefinition.has(DateFormatProperty.class)) {
            dtf = DateTimeFormat.forPattern((String)columnDefinition.lookFor(DateFormatProperty.class).getPattern());
        } else {
            throw new IllegalArgumentException("No date format pattern specified");
        }
        DateTimeZone dateTimeZone = JodaHelper.getDateTimeZone(columnDefinition);
        if (dateTimeZone != null) {
            dtf = dtf.withZone(dateTimeZone);
        } else if (dtf.getZone() == null) {
            dtf = dtf.withZone(DateTimeZone.getDefault());
        }
        return dtf;
    }

    public static DateTimeZone getDateTimeZone(ColumnDefinition<?, ?> columnDefinition) {
        if (columnDefinition.has(JodaDateTimeZoneProperty.class)) {
            return columnDefinition.lookFor(JodaDateTimeZoneProperty.class).getZone();
        }
        if (columnDefinition.has(TimeZoneProperty.class)) {
            return DateTimeZone.forTimeZone((TimeZone)columnDefinition.lookFor(TimeZoneProperty.class).getTimeZone());
        }
        return null;
    }
}

