/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc.impl.getter;

import org.sfm.map.Mapper;
import org.sfm.reflect.Getter;
import org.sfm.utils.Asserts;
import org.sfm.utils.Predicate;

public final class MapperGetterAdapter<S, P>
implements Getter<S, P> {
    private final Mapper<S, P> mapper;
    private final Predicate<S> nullChecker;

    public MapperGetterAdapter(Mapper<S, P> mapper, Predicate<S> nullChecker) {
        this.mapper = Asserts.requireNonNull("jdbcMapper", mapper);
        this.nullChecker = Asserts.requireNonNull("nullChecker", nullChecker);
    }

    @Override
    public P get(S target) throws Exception {
        if (this.nullChecker.test(target)) {
            return null;
        }
        return this.mapper.map(target);
    }

    public String toString() {
        return "MapperGetterAdapter{jdbcMapper=" + this.mapper + '}';
    }
}

