/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.sfm.jdbc.DiscriminatorJdbcBuilder;
import org.sfm.jdbc.DynamicJdbcMapper;
import org.sfm.jdbc.JdbcColumnKey;
import org.sfm.jdbc.JdbcMapper;
import org.sfm.jdbc.JdbcMapperBuilder;
import org.sfm.jdbc.JdbcMappingContextFactoryBuilder;
import org.sfm.jdbc.impl.getter.ResultSetGetterFactory;
import org.sfm.map.ColumnDefinition;
import org.sfm.map.FieldMapper;
import org.sfm.map.GetterFactory;
import org.sfm.map.SetRowMapper;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.impl.AbstractColumnDefinitionProvider;
import org.sfm.map.impl.AbstractMapperFactory;
import org.sfm.map.impl.DynamicSetRowMapper;
import org.sfm.map.impl.FieldMapperColumnDefinition;
import org.sfm.map.impl.FieldMapperColumnDefinitionProviderImpl;
import org.sfm.map.impl.MapperConfig;
import org.sfm.map.impl.MapperKey;
import org.sfm.reflect.Getter;
import org.sfm.reflect.TypeReference;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.utils.UnaryFactory;
import org.sfm.utils.UnaryFactoryWithException;

public final class JdbcMapperFactory
extends AbstractMapperFactory<JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey, ResultSet>, JdbcMapperFactory> {
    private GetterFactory<ResultSet, JdbcColumnKey> getterFactory = new ResultSetGetterFactory();

    public static JdbcMapperFactory newInstance() {
        return new JdbcMapperFactory();
    }

    private JdbcMapperFactory() {
        super((AbstractColumnDefinitionProvider)new FieldMapperColumnDefinitionProviderImpl(), (ColumnDefinition)FieldMapperColumnDefinition.identity());
    }

    public JdbcMapperFactory getterFactory(GetterFactory<ResultSet, JdbcColumnKey> getterFactory) {
        this.getterFactory = getterFactory;
        return this;
    }

    public JdbcMapperFactory addCustomFieldMapper(String key, FieldMapper<ResultSet, ?> fieldMapper) {
        return (JdbcMapperFactory)this.addColumnDefinition(key, (ColumnDefinition)FieldMapperColumnDefinition.customFieldMapperDefinition(fieldMapper));
    }

    public JdbcMapperFactory addCustomGetter(String key, Getter<ResultSet, ?> getter) {
        return (JdbcMapperFactory)this.addColumnDefinition(key, (ColumnDefinition)FieldMapperColumnDefinition.customGetter(getter));
    }

    public <T> JdbcMapper<T> newMapper(Class<T> target, ResultSetMetaData metaData) throws SQLException {
        JdbcMapperBuilder<T> builder = this.newBuilder(target);
        builder.addMapping(metaData);
        return (JdbcMapper)builder.mapper();
    }

    public <T> JdbcMapperBuilder<T> newBuilder(Class<T> target) {
        return this.newBuilder((Type)target);
    }

    public <T> JdbcMapperBuilder<T> newBuilder(TypeReference<T> target) {
        return this.newBuilder(target.getType());
    }

    public <T> JdbcMapperBuilder<T> newBuilder(Type target) {
        ClassMeta classMeta = this.getClassMeta(target);
        return this.newBuilder(classMeta);
    }

    public <T> JdbcMapperBuilder<T> newBuilder(ClassMeta<T> classMeta) {
        return new JdbcMapperBuilder<T>(classMeta, (MapperConfig<JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey, ResultSet>>)this.mapperConfig(), this.getterFactory, new JdbcMappingContextFactoryBuilder());
    }

    public <T> JdbcMapper<T> newMapper(Class<T> target) {
        return this.newMapper((Type)target);
    }

    public <T> JdbcMapper<T> newMapper(TypeReference<T> target) {
        return this.newMapper(target.getType());
    }

    public <T> JdbcMapper<T> newMapper(Type target) {
        ClassMeta classMeta = this.getClassMeta(target);
        return new DynamicJdbcSetRowMapper(new SetRowMapperFactory(classMeta), new MapperKeyFactory(), new MapperKeyFactory());
    }

    public <T> DiscriminatorJdbcBuilder<T> newDiscriminator(String column) {
        this.ignorePropertyNotFound();
        this.addColumnDefinition(column, (ColumnDefinition)FieldMapperColumnDefinition.ignoreDefinition());
        return new DiscriminatorJdbcBuilder(column, this);
    }

    private class SetRowMapperFactory<T>
    implements UnaryFactory<MapperKey<JdbcColumnKey>, SetRowMapper<ResultSet, ResultSet, T, SQLException>> {
        private final ClassMeta<T> classMeta;

        public SetRowMapperFactory(ClassMeta<T> classMeta) {
            this.classMeta = classMeta;
        }

        @Override
        public SetRowMapper<ResultSet, ResultSet, T, SQLException> newInstance(MapperKey<JdbcColumnKey> jdbcColumnKeyMapperKey) {
            JdbcMapperBuilder<T> builder = JdbcMapperFactory.this.newBuilder(this.classMeta);
            for (JdbcColumnKey key : (JdbcColumnKey[])jdbcColumnKeyMapperKey.getColumns()) {
                builder.addMapping(key, new ColumnProperty[0]);
            }
            return (SetRowMapper)builder.mapper();
        }
    }

    private static class MapperKeyFactory
    implements UnaryFactoryWithException<ResultSet, MapperKey<JdbcColumnKey>, SQLException> {
        private MapperKeyFactory() {
        }

        @Override
        public MapperKey<JdbcColumnKey> newInstance(ResultSet set) throws SQLException {
            return JdbcColumnKey.mapperKey(set.getMetaData());
        }
    }

    private static class DynamicJdbcSetRowMapper<T>
    extends DynamicSetRowMapper<ResultSet, ResultSet, T, SQLException, JdbcColumnKey>
    implements DynamicJdbcMapper<T> {
        public DynamicJdbcSetRowMapper(UnaryFactory<MapperKey<JdbcColumnKey>, SetRowMapper<ResultSet, ResultSet, T, SQLException>> mapperFactory, UnaryFactoryWithException<ResultSet, MapperKey<JdbcColumnKey>, SQLException> mapperKeyFromRow, UnaryFactoryWithException<ResultSet, MapperKey<JdbcColumnKey>, SQLException> mapperKeyFromSet) {
            super(mapperFactory, mapperKeyFromRow, mapperKeyFromSet);
        }

        @Override
        public JdbcMapper<T> getMapper(ResultSetMetaData metaData) throws SQLException {
            return (JdbcMapper)this.getMapper(JdbcColumnKey.mapperKey(metaData));
        }

        public String toString() {
            return "DynamicJdbcSetRowMapper{}";
        }
    }
}

