/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl.primitive;

import org.sfm.csv.impl.DelayedCellSetter;
import org.sfm.csv.impl.ParsingContext;
import org.sfm.csv.impl.cellreader.CharCellValueReader;
import org.sfm.reflect.primitive.CharacterSetter;

public class CharDelayedCellSetter<T>
implements DelayedCellSetter<T, Character> {
    private final CharacterSetter<T> setter;
    private final CharCellValueReader reader;
    private char value;
    private boolean isNull;

    public CharDelayedCellSetter(CharacterSetter<T> setter, CharCellValueReader reader) {
        this.setter = setter;
        this.reader = reader;
    }

    public Character consumeValue() {
        return this.isNull ? null : Character.valueOf(this.consumeCharacter());
    }

    public Character peekValue() {
        return this.isNull ? null : Character.valueOf(this.value);
    }

    public char consumeCharacter() {
        char v = this.value;
        this.value = '\u0000';
        this.isNull = true;
        return v;
    }

    public void set(T t) throws Exception {
        this.setter.setCharacter(t, this.consumeCharacter());
    }

    public boolean isSettable() {
        return this.setter != null;
    }

    public void set(char[] chars, int offset, int length, ParsingContext parsingContext) throws Exception {
        this.isNull = length == 0;
        this.value = this.reader.readChar(chars, offset, length, parsingContext);
    }

    public String toString() {
        return "CharDelayedCellSetter{setter=" + this.setter + ", reader=" + this.reader + '}';
    }
}

