/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl.primitive;

import org.sfm.csv.impl.DelayedCellSetter;
import org.sfm.csv.impl.ParsingContext;
import org.sfm.csv.impl.cellreader.BooleanCellValueReader;
import org.sfm.reflect.primitive.BooleanSetter;

public class BooleanDelayedCellSetter<T>
implements DelayedCellSetter<T, Boolean> {
    private final BooleanSetter<T> setter;
    private final BooleanCellValueReader reader;
    private boolean value;
    private boolean isNull;

    public BooleanDelayedCellSetter(BooleanSetter<T> setter, BooleanCellValueReader reader) {
        this.setter = setter;
        this.reader = reader;
    }

    public Boolean consumeValue() {
        return this.isNull ? null : Boolean.valueOf(this.consumeBoolean());
    }

    public Boolean peekValue() {
        return this.isNull ? null : Boolean.valueOf(this.value);
    }

    public boolean consumeBoolean() {
        boolean v = this.value;
        this.value = false;
        this.isNull = true;
        return v;
    }

    public void set(T t) throws Exception {
        this.setter.setBoolean(t, this.consumeBoolean());
    }

    public boolean isSettable() {
        return this.setter != null;
    }

    public void set(char[] chars, int offset, int length, ParsingContext parsingContext) throws Exception {
        this.isNull = length == 0;
        this.value = this.reader.readBoolean(chars, offset, length, parsingContext);
    }

    public String toString() {
        return "BooleanDelayedCellSetter{setter=" + this.setter + ", reader=" + this.reader + '}';
    }
}

