/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv;

import java.sql.SQLException;
import java.util.ArrayList;
import org.sfm.csv.CsvColumnKey;
import org.sfm.csv.impl.writer.CellSeparatorAppender;
import org.sfm.csv.impl.writer.CellWriter;
import org.sfm.csv.impl.writer.CsvCellWriter;
import org.sfm.csv.impl.writer.DefaultFieldAppenderFactory;
import org.sfm.csv.impl.writer.EndOfRowAppender;
import org.sfm.map.FieldKey;
import org.sfm.map.FieldMapper;
import org.sfm.map.Mapper;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.impl.ContextualMapper;
import org.sfm.map.impl.FieldMapperColumnDefinition;
import org.sfm.map.impl.MapperConfig;
import org.sfm.map.impl.MapperImpl;
import org.sfm.map.impl.PropertyMapping;
import org.sfm.map.impl.PropertyMappingsBuilder;
import org.sfm.map.impl.context.KeySourceGetter;
import org.sfm.map.impl.context.MappingContextFactoryBuilder;
import org.sfm.reflect.Instantiator;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.TypeHelper;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.utils.ErrorHelper;
import org.sfm.utils.ForEachCallBack;

public class CsvWriterBuilder<T> {
    private final ReflectionService reflectionService;
    private final MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey, T>> mapperConfig;
    private final PropertyMappingsBuilder<T, CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey, T>> propertyMappingsBuilder;
    private final DefaultFieldAppenderFactory fieldAppenderFactory;
    private final CellWriter cellWriter;
    private final ClassMeta<T> classMeta;
    private int currentIndex = 0;
    private static final AppendableInstantiator STRING_BUILDER_INSTANTIATOR = new AppendableInstantiator();

    public CsvWriterBuilder(ClassMeta<T> classMeta, MapperConfig<CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey, T>> mapperConfig, DefaultFieldAppenderFactory fieldAppenderFactory, CellWriter cellWriter) {
        this.fieldAppenderFactory = fieldAppenderFactory;
        this.cellWriter = cellWriter;
        this.reflectionService = classMeta.getReflectionService();
        this.mapperConfig = mapperConfig;
        this.propertyMappingsBuilder = new PropertyMappingsBuilder(classMeta, mapperConfig.propertyNameMatcherFactory(), mapperConfig.mapperBuilderErrorHandler());
        this.classMeta = classMeta;
    }

    public CsvWriterBuilder<T> addColumn(String column) {
        return this.addColumn(column, FieldMapperColumnDefinition.identity());
    }

    public CsvWriterBuilder<T> addColumn(String column, FieldMapperColumnDefinition<CsvColumnKey, T> columnDefinition) {
        this.propertyMappingsBuilder.addProperty((FieldKey)new CsvColumnKey(column, this.currentIndex++), columnDefinition);
        return this;
    }

    public CsvWriterBuilder<T> addColumn(String column, ColumnProperty ... properties) {
        this.propertyMappingsBuilder.addProperty((FieldKey)new CsvColumnKey(column, this.currentIndex++), FieldMapperColumnDefinition.identity().add(properties));
        return this;
    }

    public ContextualMapper<T, Appendable> mapper() {
        Object mapper;
        final ArrayList mappers = new ArrayList();
        final MappingContextFactoryBuilder mappingContextFactoryBuilder = new MappingContextFactoryBuilder(new KeySourceGetter<CsvColumnKey, T>(){

            @Override
            public Object getValue(CsvColumnKey key, T source) throws SQLException {
                throw new UnsupportedOperationException();
            }
        });
        final CellSeparatorAppender cellSeparatorAppender = new CellSeparatorAppender(this.cellWriter);
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey, T>>>(){
            int i = 0;

            @Override
            public void handle(PropertyMapping<T, ?, CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey, T>> pm) {
                FieldMapper fieldMapper = CsvWriterBuilder.this.fieldAppenderFactory.newFieldAppender(pm, CsvWriterBuilder.this.cellWriter, mappingContextFactoryBuilder);
                if (this.i > 0) {
                    mappers.add(cellSeparatorAppender);
                }
                mappers.add(fieldMapper);
                ++this.i;
            }
        });
        mappers.add(new EndOfRowAppender(this.cellWriter));
        FieldMapper[] fields = mappers.toArray(new FieldMapper[0]);
        if (mappers.size() < 256) {
            try {
                mapper = this.reflectionService.getAsmFactory().createMapper(this.getKeys(), fields, new FieldMapper[0], STRING_BUILDER_INSTANTIATOR, TypeHelper.toClass(this.classMeta.getType()), Appendable.class);
            }
            catch (Exception e) {
                if (this.mapperConfig.failOnAsm()) {
                    return (ContextualMapper)ErrorHelper.rethrow(e);
                }
                mapper = new MapperImpl(fields, new FieldMapper[0], (Instantiator)STRING_BUILDER_INSTANTIATOR);
            }
        } else {
            mapper = new MapperImpl(fields, new FieldMapper[0], (Instantiator)STRING_BUILDER_INSTANTIATOR);
        }
        return new ContextualMapper((Mapper)mapper, mappingContextFactoryBuilder.newFactory());
    }

    private FieldKey<?>[] getKeys() {
        return this.propertyMappingsBuilder.getKeys().toArray(new FieldKey[0]);
    }

    public CsvWriterBuilder<T> defaultHeaders() {
        for (String column : this.classMeta.generateHeaders()) {
            this.addColumn(column);
        }
        return this;
    }

    public static <T> CsvWriterBuilder<T> newBuilder(Class<T> clazz) {
        ClassMeta classMeta = ReflectionService.disableAsm().getClassMeta(clazz);
        return CsvWriterBuilder.newBuilder(classMeta);
    }

    public static <T> CsvWriterBuilder<T> newBuilder(ClassMeta<T> classMeta) {
        return CsvWriterBuilder.newBuilder(classMeta, CsvCellWriter.DEFAULT_WRITER);
    }

    public static <T> CsvWriterBuilder<T> newBuilder(ClassMeta<T> classMeta, CellWriter cellWriter) {
        MapperConfig config = MapperConfig.fieldMapperConfig();
        DefaultFieldAppenderFactory appenderFactory = DefaultFieldAppenderFactory.instance();
        CsvWriterBuilder<T> builder = new CsvWriterBuilder<T>(classMeta, config, appenderFactory, cellWriter);
        return builder;
    }

    private static class AppendableInstantiator
    implements Instantiator<Object, Appendable> {
        private AppendableInstantiator() {
        }

        @Override
        public Appendable newInstance(Object o) throws Exception {
            return new StringBuilder();
        }
    }
}

