/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.getter.GetterOnGetter;
import org.simpleflatmapper.reflect.getter.NullGetter;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.setter.NullSetter;

public class SubPropertyMeta<O, I, P>
extends PropertyMeta<O, P> {
    private final PropertyMeta<O, I> ownerProperty;
    private final PropertyMeta<I, P> subProperty;
    private final GetterOnGetter<O, I, P> getter;

    public SubPropertyMeta(ReflectionService reflectService, PropertyMeta<O, I> ownerProperty, PropertyMeta<I, P> subProperty) {
        super(ownerProperty.getName(), ownerProperty.getOwnerType(), reflectService);
        this.ownerProperty = ownerProperty;
        this.subProperty = subProperty;
        this.getter = new GetterOnGetter<O, I, P>(this.ownerProperty.getGetter(), subProperty.getGetter());
    }

    @Override
    public Setter<O, P> getSetter() {
        if (!NullSetter.isNull(this.subProperty.getSetter()) && !NullGetter.isNull(this.ownerProperty.getGetter())) {
            return new Setter<O, P>(){

                @Override
                public void set(O target, P value) throws Exception {
                    SubPropertyMeta.this.subProperty.getSetter().set(SubPropertyMeta.this.ownerProperty.getGetter().get(target), value);
                }
            };
        }
        return NullSetter.NULL_SETTER;
    }

    @Override
    public Getter<O, P> getGetter() {
        return this.getter;
    }

    @Override
    protected ClassMeta<P> newPropertyClassMeta() {
        return this.subProperty.getPropertyClassMeta();
    }

    @Override
    public Type getPropertyType() {
        return this.subProperty.getPropertyType();
    }

    public PropertyMeta<O, I> getOwnerProperty() {
        return this.ownerProperty;
    }

    public PropertyMeta<I, P> getSubProperty() {
        return this.subProperty;
    }

    @Override
    public boolean isSubProperty() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.subProperty.isValid();
    }

    @Override
    public String getPath() {
        return this.getOwnerProperty().getPath() + "." + this.subProperty.getPath();
    }

    public String toString() {
        return "SubPropertyMeta{ownerProperty=" + this.ownerProperty + ", subProperty=" + this.subProperty + '}';
    }
}

