/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.simpleflatmapper.reflect.Instantiator;
import org.simpleflatmapper.reflect.MethodGetterPair;
import org.simpleflatmapper.util.ErrorHelper;

public final class BuilderInstantiator<S, T>
implements Instantiator<S, T> {
    private final Instantiator<Void, ?> builderInstantiator;
    private final MethodGetterPair<S>[] chainedArguments;
    private final MethodGetterPair<S>[] unchainedArguments;
    private final Method buildMethod;

    public BuilderInstantiator(Instantiator<Void, ?> builderInstantiator, MethodGetterPair<S>[] chainedArguments, MethodGetterPair<S>[] unchainedArguments, Method buildMethod) {
        this.builderInstantiator = builderInstantiator;
        this.chainedArguments = chainedArguments;
        this.unchainedArguments = unchainedArguments;
        this.buildMethod = buildMethod;
    }

    @Override
    public T newInstance(S s) throws Exception {
        try {
            Object builder = this.builderInstantiator.newInstance(null);
            for (MethodGetterPair<S> argument : this.chainedArguments) {
                builder = argument.getMethod().invoke(builder, argument.getGetter().get(s));
            }
            for (MethodGetterPair<S> argument : this.unchainedArguments) {
                argument.getMethod().invoke(builder, argument.getGetter().get(s));
            }
            return (T)this.buildMethod.invoke(builder, new Object[0]);
        }
        catch (InvocationTargetException e) {
            return (T)ErrorHelper.rethrow((Throwable)e.getCause());
        }
    }
}

