/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.querydsl;

import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathType;
import org.sfm.map.FieldKey;
import org.sfm.map.MappingException;

public class TupleElementKey
implements FieldKey<TupleElementKey> {
    private final Expression<?> expression;
    private final int index;
    private final String name;

    public TupleElementKey(Expression<?> expression, int index) {
        PathMetadata metadata;
        if (expression instanceof Path) {
            metadata = ((Path)expression).getMetadata();
            if (metadata.getPathType() != PathType.PROPERTY) {
                throw new MappingException("Unexpected expression " + expression);
            }
        } else {
            throw new MappingException("Unexpected expression " + expression);
        }
        this.name = metadata.getElement().toString();
        this.expression = expression;
        this.index = index;
    }

    public Expression<?> getExpression() {
        return this.expression;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public TupleElementKey alias(String alias) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "TupleElementKey{expression=" + this.expression + ", index=" + this.index + ", name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TupleElementKey that = (TupleElementKey)o;
        if (this.index != that.index) {
            return false;
        }
        if (!this.expression.equals(that.expression)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.expression.hashCode();
        result = 31 * result + this.index;
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

