/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.lang.reflect.Type;
import org.simpleflatmapper.converter.ContextFactoryBuilder;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MapperBuilderErrorHandler;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.fieldmapper.BooleanConstantTargetFieldMapper;
import org.simpleflatmapper.map.fieldmapper.ByteConstantTargetFieldMapper;
import org.simpleflatmapper.map.fieldmapper.CharacterConstantTargetFieldMapper;
import org.simpleflatmapper.map.fieldmapper.ConstantTargetFieldMapper;
import org.simpleflatmapper.map.fieldmapper.DoubleConstantTargetFieldMapper;
import org.simpleflatmapper.map.fieldmapper.FloatConstantTargetFieldMapper;
import org.simpleflatmapper.map.fieldmapper.IntConstantTargetFieldMapper;
import org.simpleflatmapper.map.fieldmapper.LongConstantTargetFieldMapper;
import org.simpleflatmapper.map.fieldmapper.ShortConstantTargetFieldMapper;
import org.simpleflatmapper.map.mapper.ConstantTargetFieldMapperFactory;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.setter.BooleanContextualSetter;
import org.simpleflatmapper.map.setter.ByteContextualSetter;
import org.simpleflatmapper.map.setter.CharacterContextualSetter;
import org.simpleflatmapper.map.setter.ContextualSetter;
import org.simpleflatmapper.map.setter.ContextualSetterAdapter;
import org.simpleflatmapper.map.setter.ContextualSetterFactory;
import org.simpleflatmapper.map.setter.ContextualSetterFactoryAdapter;
import org.simpleflatmapper.map.setter.ContextualSetterOnGetter;
import org.simpleflatmapper.map.setter.DoubleContextualSetter;
import org.simpleflatmapper.map.setter.FloatContextualSetter;
import org.simpleflatmapper.map.setter.IntContextualSetter;
import org.simpleflatmapper.map.setter.LongContextualSetter;
import org.simpleflatmapper.map.setter.ShortContextualSetter;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.SetterFactory;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.ObjectClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.primitive.BooleanGetter;
import org.simpleflatmapper.reflect.primitive.ByteGetter;
import org.simpleflatmapper.reflect.primitive.CharacterGetter;
import org.simpleflatmapper.reflect.primitive.DoubleGetter;
import org.simpleflatmapper.reflect.primitive.FloatGetter;
import org.simpleflatmapper.reflect.primitive.IntGetter;
import org.simpleflatmapper.reflect.primitive.LongGetter;
import org.simpleflatmapper.reflect.primitive.ShortGetter;
import org.simpleflatmapper.util.ErrorDoc;
import org.simpleflatmapper.util.TypeHelper;

public class ConstantTargetFieldMapperFactoryImpl<T, K extends FieldKey<K>>
implements ConstantTargetFieldMapperFactory<T, K> {
    private final ContextualSetterFactory<T, PropertyMapping<?, ?, K>> setterFactory;
    private final Type targetType;

    private ConstantTargetFieldMapperFactoryImpl(ContextualSetterFactory<T, PropertyMapping<?, ?, K>> setterFactory, Type targetType) {
        this.setterFactory = setterFactory;
        this.targetType = targetType;
    }

    @Override
    public <S, P> FieldMapper<S, T> newFieldMapper(PropertyMapping<S, P, K> pm, MappingContextFactoryBuilder contextFactoryBuilder, MapperBuilderErrorHandler mappingErrorHandler) {
        Getter getter = pm.getColumnDefinition().getCustomGetterFrom(pm.getPropertyMeta().getOwnerType());
        if (getter == null) {
            getter = pm.getPropertyMeta().getGetter();
        }
        if (getter == null) {
            mappingErrorHandler.accessorNotFound("Could not find getter for " + String.valueOf(pm.getColumnKey()) + " type " + String.valueOf(pm.getPropertyMeta().getPropertyType()) + " path " + pm.getPropertyMeta().getPath() + ", See " + ErrorDoc.CTFM_GETTER_NOT_FOUND.toUrl());
            return null;
        }
        ContextualSetter<T, P> setter = this.getSetterForTarget(pm, contextFactoryBuilder);
        if (setter == null) {
            mappingErrorHandler.accessorNotFound("Could not find setter for " + String.valueOf(pm.getColumnKey()) + " type " + String.valueOf(pm.getPropertyMeta().getPropertyType()) + " path " + pm.getPropertyMeta().getPath() + " See " + ErrorDoc.CTFM_SETTER_NOT_FOUND.toUrl());
            return null;
        }
        Type propertyType = pm.getPropertyMeta().getPropertyType();
        return this.buildFieldMapper(getter, setter, propertyType);
    }

    private <S, P> FieldMapper<S, T> buildFieldMapper(Getter<? super S, ? extends P> getter, ContextualSetter<? super T, ? super P> setter, Type propertyType) {
        if (TypeHelper.isPrimitive((Type)propertyType)) {
            if (getter instanceof BooleanGetter && setter instanceof BooleanContextualSetter) {
                return new BooleanConstantTargetFieldMapper((BooleanGetter)getter, (BooleanContextualSetter)((Object)setter));
            }
            if (getter instanceof ByteGetter && setter instanceof ByteContextualSetter) {
                return new ByteConstantTargetFieldMapper((ByteGetter)getter, (ByteContextualSetter)((Object)setter));
            }
            if (getter instanceof CharacterGetter && setter instanceof CharacterContextualSetter) {
                return new CharacterConstantTargetFieldMapper((CharacterGetter)getter, (CharacterContextualSetter)((Object)setter));
            }
            if (getter instanceof ShortGetter && setter instanceof ShortContextualSetter) {
                return new ShortConstantTargetFieldMapper((ShortGetter)getter, (ShortContextualSetter)((Object)setter));
            }
            if (getter instanceof IntGetter && setter instanceof IntContextualSetter) {
                return new IntConstantTargetFieldMapper((IntGetter)getter, (IntContextualSetter)((Object)setter));
            }
            if (getter instanceof LongGetter && setter instanceof LongContextualSetter) {
                return new LongConstantTargetFieldMapper((LongGetter)getter, (LongContextualSetter)((Object)setter));
            }
            if (getter instanceof FloatGetter && setter instanceof FloatContextualSetter) {
                return new FloatConstantTargetFieldMapper((FloatGetter)getter, (FloatContextualSetter)((Object)setter));
            }
            if (getter instanceof DoubleGetter && setter instanceof DoubleContextualSetter) {
                return new DoubleConstantTargetFieldMapper((DoubleGetter)getter, (DoubleContextualSetter)((Object)setter));
            }
        }
        return new ConstantTargetFieldMapper<S, T, P>(getter, setter);
    }

    private <S, P> ContextualSetter<T, P> getSetterForTarget(PropertyMapping<S, ?, K> pm, ContextFactoryBuilder contextFactoryBuilder) {
        PropertyMeta subProp;
        ContextualSetter<T, P> subSetter;
        ObjectClassMeta ocm;
        ClassMeta propertyClassMeta;
        ContextualSetter<Object, Object> setter = ContextualSetterAdapter.of(pm.getColumnDefinition().getCustomSetterTo(this.targetType));
        SetterFactory<?, ?> customSetterFactory = pm.getColumnDefinition().getCustomSetterFactoryTo(this.targetType);
        if (customSetterFactory != null) {
            setter = ContextualSetterAdapter.of(customSetterFactory.getSetter(pm));
        }
        if (setter == null) {
            setter = this.setterFactory.getSetter(pm, contextFactoryBuilder);
        }
        if (setter == null && !pm.getPropertyMeta().isSelf() && (propertyClassMeta = pm.getPropertyMeta().getPropertyClassMeta()) instanceof ObjectClassMeta && (ocm = (ObjectClassMeta)propertyClassMeta).getNumberOfProperties() == 1 && (subSetter = this.getSetterForTarget(pm.propertyMeta(subProp = ocm.getFirstProperty()), contextFactoryBuilder)) != null) {
            return new ContextualSetterOnGetter(subSetter, subProp.getGetter());
        }
        return setter;
    }

    public static <T, K extends FieldKey<K>> ConstantTargetFieldMapperFactory<T, K> newInstance(SetterFactory<T, PropertyMapping<?, ?, K>> setterFactory, Type targetType) {
        return ConstantTargetFieldMapperFactoryImpl.newInstance(new ContextualSetterFactoryAdapter(setterFactory), targetType);
    }

    public static <T, K extends FieldKey<K>> ConstantTargetFieldMapperFactory<T, K> newInstance(ContextualSetterFactory<T, PropertyMapping<?, ?, K>> setterFactory, Type targetType) {
        return new ConstantTargetFieldMapperFactoryImpl<T, K>(setterFactory, targetType);
    }
}

