/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.map.CaseInsensitiveFieldKeyNamePredicate;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.ColumnDefinitionProvider;
import org.simpleflatmapper.map.property.GetterProperty;
import org.simpleflatmapper.map.property.SetterProperty;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.util.BiConsumer;
import org.simpleflatmapper.util.ConstantUnaryFactory;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.UnaryFactory;

public abstract class AbstractColumnDefinitionProvider<K extends FieldKey<K>>
implements ColumnDefinitionProvider<K> {
    protected final List<PredicatedColumnPropertyFactory<K>> properties;

    public AbstractColumnDefinitionProvider() {
        this(new ArrayList<PredicatedColumnPropertyFactory<K>>());
    }

    public AbstractColumnDefinitionProvider(List<PredicatedColumnPropertyFactory<K>> properties) {
        this.properties = properties;
    }

    public void addColumnDefinition(Predicate<? super K> predicate, ColumnDefinition<K, ?> definition) {
        for (Object prop : definition.properties()) {
            this.addColumnProperty(predicate, this.newFactory(prop));
        }
    }

    public void addColumnDefinition(String name, ColumnDefinition<K, ?> definition) {
        CaseInsensitiveFieldKeyNamePredicate predicate = this.newPredicate(name);
        for (Object prop : definition.properties()) {
            this.addColumnProperty((Predicate<? super K>)predicate, (UnaryFactory<? super K, Object>)this.newFactory(prop));
        }
    }

    public void addColumnProperty(String name, Object property) {
        this.addColumnProperty((Predicate<? super K>)this.newPredicate(name), (UnaryFactory<? super K, Object>)this.newFactory(property));
    }

    public void addColumnProperty(Predicate<? super K> predicate, Object property) {
        this.addColumnProperty(predicate, this.newFactory(property));
    }

    public void addColumnProperty(Predicate<? super K> predicate, UnaryFactory<? super K, Object> propertyFactory) {
        this.properties.add(new PredicatedColumnPropertyFactory<K>(predicate, propertyFactory));
    }

    private CaseInsensitiveFieldKeyNamePredicate newPredicate(String name) {
        return CaseInsensitiveFieldKeyNamePredicate.of(name);
    }

    private UnaryFactory<? super K, Object> newFactory(Object prop) {
        return ConstantUnaryFactory.of((Object)this.upgrade(prop));
    }

    private Object upgrade(Object property) {
        if (property instanceof Setter) {
            return new SetterProperty((Setter)property);
        }
        if (property instanceof Getter) {
            return new GetterProperty((Getter)property);
        }
        return property;
    }

    @Override
    public ColumnDefinition<K, ?> getColumnDefinition(K key) {
        ColumnDefinition<K, Object> definition = this.identity();
        for (int i = this.properties.size() - 1; i >= 0; --i) {
            Object columnProperty;
            PredicatedColumnPropertyFactory<K> tuple2 = this.properties.get(i);
            if (!((PredicatedColumnPropertyFactory)tuple2).predicate.test(key) || (columnProperty = ((PredicatedColumnPropertyFactory)tuple2).columnPropertyFactory.newInstance(key)) == null) continue;
            definition = definition.add(columnProperty);
        }
        return definition;
    }

    public abstract AbstractColumnDefinitionProvider<K> copy();

    protected abstract ColumnDefinition<K, ?> identity();

    public List<PredicatedColumnPropertyFactory<K>> getProperties() {
        return this.properties;
    }

    @Override
    public <CP, BC extends BiConsumer<Predicate<? super K>, CP>> BC forEach(Class<CP> propertyType, BC consumer) {
        for (PredicatedColumnPropertyFactory<K> tuple2 : this.properties) {
            Object columnProperty;
            UnaryFactory unaryFactory = ((PredicatedColumnPropertyFactory)tuple2).columnPropertyFactory;
            if (!(unaryFactory instanceof ConstantUnaryFactory) || !propertyType.isInstance(columnProperty = unaryFactory.newInstance(null))) continue;
            consumer.accept((Object)((PredicatedColumnPropertyFactory)tuple2).predicate, propertyType.cast(columnProperty));
        }
        return consumer;
    }

    public void addColumnProperty(PredicatedColumnPropertyFactory predicatedColumnPropertyFactory) {
        this.properties.add(predicatedColumnPropertyFactory);
    }

    public static class PredicatedColumnPropertyFactory<K extends FieldKey<K>> {
        private final Predicate<? super K> predicate;
        private final UnaryFactory<? super K, Object> columnPropertyFactory;

        public PredicatedColumnPropertyFactory(Predicate<? super K> predicate, UnaryFactory<? super K, Object> columnPropertyFactory) {
            this.predicate = predicate;
            this.columnPropertyFactory = columnPropertyFactory;
        }

        public Predicate<? super K> getPredicate() {
            return this.predicate;
        }

        public UnaryFactory<? super K, Object> getColumnPropertyFactory() {
            return this.columnPropertyFactory;
        }
    }
}

