/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.simpleflatmapper.map.CaseInsensitiveFieldKeyNamePredicate;
import org.simpleflatmapper.map.ConsumerErrorHandler;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapperErrorHandler;
import org.simpleflatmapper.map.MapperBuilderErrorHandler;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.PropertyNameMatcherFactory;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.error.RethrowConsumerErrorHandler;
import org.simpleflatmapper.map.error.RethrowMapperBuilderErrorHandler;
import org.simpleflatmapper.map.getter.ComposedContextualGetterFactory;
import org.simpleflatmapper.map.getter.ContextualGetter;
import org.simpleflatmapper.map.getter.ContextualGetterFactory;
import org.simpleflatmapper.map.mapper.AbstractColumnDefinitionProvider;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.ColumnDefinitionProvider;
import org.simpleflatmapper.map.mapper.DefaultPropertyNameMatcherFactory;
import org.simpleflatmapper.map.property.IgnoreProperty;
import org.simpleflatmapper.map.property.OptionalProperty;
import org.simpleflatmapper.map.property.RenameProperty;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.util.CheckedBiFunction;
import org.simpleflatmapper.util.ConstantPredicate;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.EqualsPredicate;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.Function;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;
import org.simpleflatmapper.util.TypeReference;
import org.simpleflatmapper.util.UnaryFactory;

public abstract class AbstractMapperFactory<K extends FieldKey<K>, MF extends AbstractMapperFactory<K, MF, S>, S> {
    private FieldMapperErrorHandler<K> fieldMapperErrorHandler = null;
    private MapperBuilderErrorHandler mapperBuilderErrorHandler = RethrowMapperBuilderErrorHandler.INSTANCE;
    private ConsumerErrorHandler consumerErrorHandler = RethrowConsumerErrorHandler.INSTANCE;
    private final AbstractColumnDefinitionProvider<K> columnDefinitions;
    private final List<TypedPredicatedPredicatedColumnPropertyFactory<K>> typedPredicatedPredicatedColunnPropertyFactories = new ArrayList<TypedPredicatedPredicatedColumnPropertyFactory<K>>();
    private final List<MapperConfig.Discriminator<S, ?>> discriminators = new ArrayList();
    private final ColumnDefinition<K, ?> identity;
    private boolean useAsm = true;
    private boolean failOnAsm = false;
    private int asmMapperNbFieldsLimit = 792;
    private PropertyNameMatcherFactory propertyNameMatcherFactory = DefaultPropertyNameMatcherFactory.DEFAULT;
    private ReflectionService reflectionService = null;
    private int maxMethodSize = 128;
    private boolean assumeInjectionModifiesValues;
    private Predicate<? super S> rowFilter = null;
    private boolean unorderedJoin;
    protected ContextualGetterFactory<? super S, K> getterFactory;

    public AbstractMapperFactory(AbstractMapperFactory<K, ?, S> config) {
        this.fieldMapperErrorHandler = config.fieldMapperErrorHandler;
        this.mapperBuilderErrorHandler = config.mapperBuilderErrorHandler;
        this.consumerErrorHandler = config.consumerErrorHandler;
        this.columnDefinitions = config.columnDefinitions;
        this.identity = config.identity;
        this.useAsm = config.useAsm;
        this.failOnAsm = config.failOnAsm;
        this.asmMapperNbFieldsLimit = config.asmMapperNbFieldsLimit;
        this.propertyNameMatcherFactory = config.propertyNameMatcherFactory;
        this.reflectionService = config.reflectionService;
        this.maxMethodSize = config.maxMethodSize;
        this.assumeInjectionModifiesValues = config.assumeInjectionModifiesValues;
        this.rowFilter = config.rowFilter;
        this.unorderedJoin = config.unorderedJoin;
        this.getterFactory = config.getterFactory;
    }

    public AbstractMapperFactory(AbstractColumnDefinitionProvider<K> columnDefinitions, ColumnDefinition<K, ?> identity, ContextualGetterFactory<? super S, K> getterFactory) {
        this.columnDefinitions = columnDefinitions;
        this.identity = identity;
        this.getterFactory = getterFactory;
    }

    public AbstractMapperFactory(AbstractColumnDefinitionProvider<K> columnDefinitions, ColumnDefinition<K, ?> identity, Function<MF, ? extends ContextualGetterFactory<? super S, K>> getterFactoryFactory) {
        this.columnDefinitions = columnDefinitions;
        this.identity = identity;
        this.getterFactory = (ContextualGetterFactory)getterFactoryFactory.apply((Object)this);
    }

    public final MF fieldMapperErrorHandler(FieldMapperErrorHandler<K> fieldMapperErrorHandler) {
        this.fieldMapperErrorHandler = fieldMapperErrorHandler;
        return (MF)this;
    }

    public final MF unorderedJoin() {
        this.unorderedJoin = true;
        return (MF)this;
    }

    public final MF ignorePropertyNotFound() {
        return this.addColumnProperty((Predicate<? super K>)ConstantPredicate.truePredicate(), OptionalProperty.INSTANCE);
    }

    public final MF mapperBuilderErrorHandler(MapperBuilderErrorHandler mapperBuilderErrorHandler) {
        this.mapperBuilderErrorHandler = mapperBuilderErrorHandler;
        return (MF)this;
    }

    public final MF consumerErrorHandler(ConsumerErrorHandler consumerErrorHandler) {
        this.consumerErrorHandler = consumerErrorHandler;
        return (MF)this;
    }

    @Deprecated
    public final MF rowHandlerErrorHandler(ConsumerErrorHandler rowHandlerErrorHandler) {
        return this.consumerErrorHandler(rowHandlerErrorHandler);
    }

    public final MF useAsm(boolean useAsm) {
        if (this.reflectionService != null) {
            throw new IllegalStateException("Reflection service is set cannot change useAsm");
        }
        this.useAsm = useAsm;
        return (MF)this;
    }

    public final MF reflectionService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
        return (MF)this;
    }

    public final MF rowFilter(Predicate<? super S> rowFilter) {
        this.rowFilter = rowFilter;
        return (MF)this;
    }

    public final MapperConfig<K, S> mapperConfig() {
        return this.mapperConfig((Type)((Object)Object.class));
    }

    public final MapperConfig<K, S> mapperConfig(Type targetType) {
        return MapperConfig.config(this.enrichColumnDefinitions(this.columnDefinitions(targetType))).mapperBuilderErrorHandler(this.mapperBuilderErrorHandler).propertyNameMatcherFactory(this.propertyNameMatcherFactory).failOnAsm(this.failOnAsm).asmMapperNbFieldsLimit(this.asmMapperNbFieldsLimit).fieldMapperErrorHandler(this.fieldMapperErrorHandler).consumerErrorHandler(this.consumerErrorHandler).maxMethodSize(this.maxMethodSize).assumeInjectionModifiesValues(this.assumeInjectionModifiesValues).discriminators(this.discriminators).rowFilter(this.rowFilter).unorderedJoin(this.unorderedJoin);
    }

    public AbstractColumnDefinitionProvider<K> enrichColumnDefinitions(AbstractColumnDefinitionProvider<K> columnDefinitions) {
        return columnDefinitions;
    }

    public final MF addAlias(String column, String actualPropertyName) {
        return this.addColumnDefinition(column, (ColumnDefinition<K, ?>)this.identity.addRename(actualPropertyName));
    }

    public final MF addAliasForType(Type type, String column, String actualPropertyName) {
        return this.addColumnPropertyForType(type, column, new RenameProperty(actualPropertyName));
    }

    public final MF addColumnDefinition(String column, ColumnDefinition<K, ?> columnDefinition) {
        this.columnDefinitions.addColumnDefinition(column, columnDefinition);
        return (MF)this;
    }

    public final MF addColumnDefinition(Predicate<? super K> predicate, ColumnDefinition<K, ?> columnDefinition) {
        this.columnDefinitions.addColumnDefinition(predicate, columnDefinition);
        return (MF)this;
    }

    public final MF addColumnProperty(String column, Object ... properties) {
        for (Object property : properties) {
            this.columnDefinitions.addColumnProperty(column, property);
        }
        return (MF)this;
    }

    public final MF addColumnProperty(Predicate<? super K> predicate, Object ... properties) {
        for (Object property : properties) {
            this.columnDefinitions.addColumnProperty(predicate, property);
        }
        return (MF)this;
    }

    public final MF addColumnProperty(Predicate<? super K> predicate, UnaryFactory<K, Object> propertyFactory) {
        this.columnDefinitions.addColumnProperty(predicate, propertyFactory);
        return (MF)this;
    }

    public final MF addColumnPropertyForType(Type type, String column, Object ... properties) {
        return this.addColumnPropertyForType(type, CaseInsensitiveFieldKeyNamePredicate.of(column), properties);
    }

    public final MF addColumnPropertyForType(Type type, Predicate<? super K> keyPredicate, Object ... properties) {
        for (final Object property : properties) {
            this.addColumnPropertyForType(type, keyPredicate, new UnaryFactory<K, Object>(){

                public Object newInstance(K k) {
                    return property;
                }
            });
        }
        return (MF)this;
    }

    public final MF addColumnPropertyForType(final Type type, Predicate<? super K> keyPredicate, UnaryFactory<K, Object> propertyFactory) {
        return this.addColumnPropertyForType(new Predicate<Type>(){

            public boolean test(Type t) {
                return TypeHelper.areEquals((Type)type, (Type)t);
            }
        }, keyPredicate, propertyFactory);
    }

    public final MF addColumnPropertyForType(Predicate<Type> typePredicate, Predicate<? super K> keyPredicate, UnaryFactory<K, Object> propertyFactory) {
        this.typedPredicatedPredicatedColunnPropertyFactories.add(new TypedPredicatedPredicatedColumnPropertyFactory(typePredicate, new AbstractColumnDefinitionProvider.PredicatedColumnPropertyFactory<K>(keyPredicate, propertyFactory)));
        return (MF)this;
    }

    public final MF propertyNameMatcherFactory(PropertyNameMatcherFactory propertyNameMatcherFactory) {
        this.propertyNameMatcherFactory = propertyNameMatcherFactory;
        return (MF)this;
    }

    public final MF addAliases(Map<String, String> aliases) {
        for (Map.Entry<String, String> e : aliases.entrySet()) {
            this.addAlias(e.getKey(), e.getValue());
        }
        return (MF)this;
    }

    public final MF ignoreColumns(Predicate<? super K> predicate) {
        return this.addColumnProperty(predicate, new IgnoreProperty());
    }

    public final MF ignoreColumns(String ... columnNames) {
        return this.ignoreColumns(Arrays.asList(columnNames));
    }

    public MF addGetterFactory(ContextualGetterFactory<S, K> getterFactory) {
        this.getterFactory = ComposedContextualGetterFactory.composed(getterFactory, this.getterFactory);
        return (MF)this;
    }

    public MF addGetterForType(final Type type, Function<K, ContextualGetter<S, ?>> getterFactory) {
        return this.addGetterForType(new Predicate<Type>(){

            public boolean test(Type t) {
                return TypeHelper.isAssignable((Type)t, (Type)type);
            }
        }, getterFactory);
    }

    public MF addGetterForType(final Type type, ContextualGetterFactory<S, K> getterFactory) {
        return this.addGetterForType(new Predicate<Type>(){

            public boolean test(Type t) {
                return TypeHelper.isAssignable((Type)t, (Type)type);
            }
        }, getterFactory);
    }

    public MF addGetterForType(final Predicate<Type> typePredicate, final Function<K, ContextualGetter<S, ?>> getterFactory) {
        return this.addGetterFactory(new ContextualGetterFactory<S, K>(){

            @Override
            public <P> ContextualGetter<S, P> newGetter(Type target, K key, MappingContextFactoryBuilder<?, K> mappingContextFactoryBuilder, Object ... properties) {
                if (typePredicate.test((Object)target)) {
                    return (ContextualGetter)getterFactory.apply(key);
                }
                return null;
            }
        });
    }

    public MF addGetterForType(final Predicate<Type> typePredicate, final ContextualGetterFactory<S, K> getterFactory) {
        return this.addGetterFactory(new ContextualGetterFactory<S, K>(){

            @Override
            public <P> ContextualGetter<S, P> newGetter(Type target, K key, MappingContextFactoryBuilder<?, K> mappingContextFactoryBuilder, Object ... properties) {
                if (typePredicate.test((Object)target)) {
                    return getterFactory.newGetter(target, key, mappingContextFactoryBuilder, properties);
                }
                return null;
            }
        });
    }

    public final MF ignoreColumns(Collection<String> columnNames) {
        final HashSet<String> columnSet = new HashSet<String>();
        for (String c : columnNames) {
            columnSet.add(c.toUpperCase());
        }
        return this.ignoreColumns(new Predicate<K>(){

            public boolean test(K k) {
                return columnSet.contains(((FieldKey)k).getName().toUpperCase());
            }
        });
    }

    public final MF failOnAsm(boolean b) {
        this.failOnAsm = b;
        return (MF)this;
    }

    public final MF assumeInjectionModifiesValues(boolean b) {
        this.assumeInjectionModifiesValues = b;
        return (MF)this;
    }

    public final MF asmMapperNbFieldsLimit(int asmMapperNbFieldsLimit) {
        this.asmMapperNbFieldsLimit = asmMapperNbFieldsLimit;
        return (MF)this;
    }

    public final MF maxMethodSize(int maxMethodSize) {
        this.maxMethodSize = maxMethodSize;
        return (MF)this;
    }

    public final MF addKeys(String ... columns) {
        for (String col : columns) {
            this.addColumnDefinition(col, (ColumnDefinition<K, ?>)this.identity.addKey());
        }
        return (MF)this;
    }

    public final ConsumerErrorHandler consumerErrorHandler() {
        return this.consumerErrorHandler;
    }

    public final <T> ClassMeta<T> getClassMeta(TypeReference<T> target) {
        return this.getClassMeta(target.getType());
    }

    public final <T> ClassMeta<T> getClassMeta(Class<T> target) {
        return this.getClassMeta((Type)target);
    }

    public final <T> ClassMeta<T> getClassMeta(Type target) {
        return this.getReflectionService().getClassMeta(target);
    }

    public final <T> ClassMeta<T> getClassMetaWithExtraInstantiator(TypeReference<T> target, Member instantiator) {
        return this.getClassMetaWithExtraInstantiator(target.getType(), instantiator);
    }

    public final <T> ClassMeta<T> getClassMetaWithExtraInstantiator(Class<T> target, Member instantiator) {
        return this.getClassMetaWithExtraInstantiator((Type)target, instantiator);
    }

    public final <T> ClassMeta<T> getClassMetaWithExtraInstantiator(Type target, Member instantiator) {
        return this.getReflectionService().getClassMetaExtraInstantiator(target, instantiator);
    }

    public ReflectionService getReflectionService() {
        if (this.reflectionService == null) {
            this.reflectionService = ReflectionService.newInstance((boolean)this.useAsm);
        }
        return this.reflectionService;
    }

    public ColumnDefinitionProvider<K> columnDefinitions() {
        return this.columnDefinitions;
    }

    public AbstractColumnDefinitionProvider<K> columnDefinitions(Type targetType) {
        AbstractColumnDefinitionProvider<K> provider = this.columnDefinitions.copy();
        for (TypedPredicatedPredicatedColumnPropertyFactory<K> f : this.typedPredicatedPredicatedColunnPropertyFactories) {
            if (!((TypedPredicatedPredicatedColumnPropertyFactory)f).predicate.test((Object)targetType)) continue;
            provider.addColumnProperty(((TypedPredicatedPredicatedColumnPropertyFactory)f).predicatedColumnPropertyFactory);
        }
        return provider;
    }

    public <T> MF discriminator(Type commonType, Consumer<DiscriminatorBuilder<S, T>> consumer) {
        DiscriminatorBuilder db = new DiscriminatorBuilder(commonType, this.getReflectionService());
        consumer.accept(db);
        this.discriminators.add(new MapperConfig.Discriminator(commonType, db.cases.toArray(new MapperConfig.DiscriminatorCase[0])));
        return (MF)this;
    }

    public <T, V> MF discriminator(Type commonType, Getter<? super S, ? extends V> getter, Consumer<DiscriminatorConditionBuilder<S, V, T>> consumer) {
        DiscriminatorBuilder db = new DiscriminatorBuilder(commonType, this.getReflectionService());
        DiscriminatorConditionBuilder dcb = new DiscriminatorConditionBuilder(db, getter);
        consumer.accept(dcb);
        this.discriminators.add(new MapperConfig.Discriminator(commonType, db.cases.toArray(new MapperConfig.DiscriminatorCase[0])));
        return (MF)this;
    }

    public <T> MF discriminator(Class<T> commonType, Consumer<DiscriminatorBuilder<S, T>> consumer) {
        return this.discriminator((Type)commonType, consumer);
    }

    public <T, V> MF discriminator(Class<T> commonType, Getter<? super S, ? extends V> getter, Consumer<DiscriminatorConditionBuilder<S, V, T>> consumer) {
        return this.discriminator((Type)commonType, getter, consumer);
    }

    public <T, V> MF discriminator(Class<T> commonType, String discriminatorColumn, CheckedBiFunction<S, String, V> discriminatorFieldAccessor, Consumer<DiscriminatorConditionBuilder<S, V, T>> consumer) {
        return this.discriminator((Type)commonType, discriminatorColumn, discriminatorFieldAccessor, consumer);
    }

    public <T, V> MF discriminator(Type commonType, final String discriminatorColumn, final CheckedBiFunction<S, String, V> discriminatorFieldAccessor, Consumer<DiscriminatorConditionBuilder<S, V, T>> consumer) {
        this.addColumnProperty(discriminatorColumn, OptionalProperty.INSTANCE);
        Getter getter = new Getter<S, V>(){

            public V get(S target) throws Exception {
                return discriminatorFieldAccessor.apply(target, (Object)discriminatorColumn);
            }
        };
        return this.discriminator(commonType, getter, consumer);
    }

    private class TypedPredicatedPredicatedColumnPropertyFactory<K> {
        private final Predicate<Type> predicate;
        private final AbstractColumnDefinitionProvider.PredicatedColumnPropertyFactory predicatedColumnPropertyFactory;

        private TypedPredicatedPredicatedColumnPropertyFactory(Predicate<Type> predicate, AbstractColumnDefinitionProvider.PredicatedColumnPropertyFactory predicatedColumnPropertyFactory) {
            this.predicate = predicate;
            this.predicatedColumnPropertyFactory = predicatedColumnPropertyFactory;
        }
    }

    public static final class DiscriminatorBuilder<S, T> {
        private final Type commonType;
        private final ReflectionService reflectionService;
        List<MapperConfig.DiscriminatorCase<S, T>> cases = new ArrayList<MapperConfig.DiscriminatorCase<S, T>>();

        public DiscriminatorBuilder(Type type, ReflectionService reflectionService) {
            this.commonType = type;
            this.reflectionService = reflectionService;
        }

        public DiscriminatorBuilder<S, T> when(Predicate<S> predicate, ClassMeta<? extends T> classMeta) {
            return this.discriminatorCase(predicate, classMeta);
        }

        public DiscriminatorBuilder<S, T> when(Predicate<S> predicate, Class<? extends T> target) {
            return this.discriminatorCase(predicate, target);
        }

        public DiscriminatorBuilder<S, T> when(Predicate<S> predicate, Type target) {
            return this.discriminatorCase(predicate, target);
        }

        public DiscriminatorBuilder<S, T> discriminatorCase(Predicate<S> predicate, ClassMeta<? extends T> classMeta) {
            MapperConfig.DiscriminatorCase<S, ? extends T> dCase = new MapperConfig.DiscriminatorCase<S, T>(predicate, classMeta);
            this.cases.add(dCase);
            return this;
        }

        public DiscriminatorBuilder<S, T> discriminatorCase(Predicate<S> predicate, Class<? extends T> target) {
            return this.discriminatorCase(predicate, this.reflectionService.getClassMeta(target));
        }

        public DiscriminatorBuilder<S, T> discriminatorCase(Predicate<S> predicate, Type target) {
            if (!TypeHelper.isAssignable((Type)this.commonType, (Type)target)) {
                throw new IllegalArgumentException("type " + target + " is not a subclass of " + this.commonType);
            }
            return this.discriminatorCase(predicate, this.reflectionService.getClassMeta(target));
        }
    }

    public static class DiscriminatorConditionBuilder<S, V, T> {
        private final DiscriminatorBuilder<S, T> discriminatorBuilder;
        private final Getter<? super S, ? extends V> getter;

        public DiscriminatorConditionBuilder(DiscriminatorBuilder<S, T> discriminatorBuilder, Getter<? super S, ? extends V> getter) {
            this.discriminatorBuilder = discriminatorBuilder;
            this.getter = getter;
        }

        public DiscriminatorConditionBuilder<S, V, T> when(V value, Type type) {
            return this.discriminatorCase(value, type);
        }

        public DiscriminatorConditionBuilder<S, V, T> when(V value, Class<T> type) {
            return this.discriminatorCase(value, type);
        }

        public DiscriminatorConditionBuilder<S, V, T> when(V value, ClassMeta<? extends T> classMeta) {
            return this.discriminatorCase(value, classMeta);
        }

        public DiscriminatorConditionBuilder<S, V, T> when(Predicate<V> predicate, Type type) {
            return this.discriminatorCase(predicate, type);
        }

        public DiscriminatorConditionBuilder<S, V, T> when(Predicate<V> predicate, Class<T> type) {
            return this.discriminatorCase(predicate, type);
        }

        public DiscriminatorConditionBuilder<S, V, T> when(Predicate<V> predicate, ClassMeta<? extends T> classMeta) {
            return this.discriminatorCase(predicate, classMeta);
        }

        public DiscriminatorConditionBuilder<S, V, T> discriminatorCase(V value, Type type) {
            return this.discriminatorCase(this.toEqualsPredicate(value), type);
        }

        public DiscriminatorConditionBuilder<S, V, T> discriminatorCase(V value, Class<T> type) {
            return this.discriminatorCase(this.toEqualsPredicate(value), type);
        }

        public DiscriminatorConditionBuilder<S, V, T> discriminatorCase(V value, ClassMeta<? extends T> classMeta) {
            return this.discriminatorCase(this.toEqualsPredicate(value), classMeta);
        }

        public DiscriminatorConditionBuilder<S, V, T> discriminatorCase(Predicate<V> predicate, Type type) {
            this.discriminatorBuilder.when(this.toSourcePredicate(predicate), type);
            return this;
        }

        public DiscriminatorConditionBuilder<S, V, T> discriminatorCase(Predicate<V> predicate, Class<T> type) {
            this.discriminatorBuilder.when(this.toSourcePredicate(predicate), type);
            return this;
        }

        public DiscriminatorConditionBuilder<S, V, T> discriminatorCase(Predicate<V> predicate, ClassMeta<? extends T> classMeta) {
            this.discriminatorBuilder.when(this.toSourcePredicate(predicate), classMeta);
            return this;
        }

        private Predicate<V> toEqualsPredicate(V value) {
            return EqualsPredicate.of(value);
        }

        private Predicate<S> toSourcePredicate(Predicate<V> predicate) {
            return new SourcePredicate<S, V>(predicate, this.getter);
        }

        static class SourcePredicate<S, V>
        implements Predicate<S> {
            final Predicate<? super V> predicate;
            final Getter<? super S, ? extends V> getter;

            public SourcePredicate(Predicate<? super V> predicate, Getter<? super S, ? extends V> getter) {
                this.predicate = predicate;
                this.getter = getter;
            }

            public boolean test(S s) {
                try {
                    return this.predicate.test(this.getter.get(s));
                }
                catch (Exception e) {
                    return (Boolean)ErrorHelper.rethrow((Throwable)e);
                }
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SourcePredicate that = (SourcePredicate)o;
                if (this.predicate != null ? !this.predicate.equals(that.predicate) : that.predicate != null) {
                    return false;
                }
                return this.getter != null ? this.getter.equals(that.getter) : that.getter == null;
            }

            public int hashCode() {
                int result = this.predicate != null ? this.predicate.hashCode() : 0;
                result = 31 * result + (this.getter != null ? this.getter.hashCode() : 0);
                return result;
            }
        }
    }
}

