/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import org.simpleflatmapper.map.ContextualSourceFieldMapper;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.mapper.MapperCache;
import org.simpleflatmapper.map.mapper.MapperKey;
import org.simpleflatmapper.map.mapper.MapperKeyComparator;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.UnaryFactory;
import org.simpleflatmapper.util.UnaryFactoryWithException;

public class DynamicSourceFieldMapper<ROW, T, K extends FieldKey<K>, E extends Exception>
implements ContextualSourceFieldMapper<ROW, T> {
    private final MapperCache<K, ContextualSourceFieldMapper<ROW, T>> mapperCache;
    private final UnaryFactory<MapperKey<K>, ContextualSourceFieldMapper<ROW, T>> mapperFactory;
    private final UnaryFactoryWithException<ROW, MapperKey<K>, E> mapperKeyFromRow;

    public DynamicSourceFieldMapper(UnaryFactory<MapperKey<K>, ContextualSourceFieldMapper<ROW, T>> mapperFactory, UnaryFactoryWithException<ROW, MapperKey<K>, E> mapperKeyFromRow, MapperKeyComparator<K> keyComparator) {
        this.mapperFactory = mapperFactory;
        this.mapperKeyFromRow = mapperKeyFromRow;
        this.mapperCache = new MapperCache(keyComparator);
    }

    @Override
    public T map(ROW row) throws MappingException {
        try {
            return this.getMapperFromRow(row).map(row);
        }
        catch (Exception e) {
            return (T)ErrorHelper.rethrow((Throwable)e);
        }
    }

    @Override
    public final T map(ROW row, MappingContext<? super ROW> context) throws MappingException {
        try {
            return this.getMapperFromRow(row).map(row, context);
        }
        catch (Exception e) {
            return (T)ErrorHelper.rethrow((Throwable)e);
        }
    }

    @Override
    public void mapTo(ROW row, T target, MappingContext<? super ROW> context) throws Exception {
        try {
            this.getMapperFromRow(row).mapTo(row, target, context);
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
        }
    }

    public String toString() {
        return "DynamicMapper{mapperFactory=" + this.mapperFactory + ", " + this.mapperCache + '}';
    }

    private ContextualSourceFieldMapper<ROW, T> getMapperFromRow(ROW row) throws E {
        return this.getMapper((MapperKey)this.mapperKeyFromRow.newInstance(row));
    }

    public ContextualSourceFieldMapper<ROW, T> getMapper(MapperKey<K> key) {
        ContextualSourceFieldMapper mapper = this.mapperCache.get(key);
        if (mapper == null) {
            mapper = (ContextualSourceFieldMapper)this.mapperFactory.newInstance(key);
            this.mapperCache.add(key, mapper);
        }
        return mapper;
    }
}

